% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading-state.R
\name{add_loading_state}
\alias{add_loading_state}
\title{Loading state for Shiny Outputs}
\usage{
add_loading_state(
  selector,
  spinner = c("standard", "hourglass", "circle", "arrows", "dots", "pulse"),
  text = NULL,
  timeout = 600,
  svgColor = "#383838",
  svgSize = "45px",
  messageColor = "#383838",
  messageFontSize = "14px",
  backgroundColor = "rgba(255,255,255,0.9)",
  ...
)
}
\arguments{
\item{selector}{CSS selector to match outputs, for example use \code{".shiny-plot-output"}
to select all \code{\link[shiny:plotOutput]{shiny::plotOutput()}} in your application, or \code{"#my_chart"} to select
a specific output. You can use a vector to select multiple outputs.}

\item{spinner}{Name of the spinner to use.}

\item{text}{An optional text to be displayed under the spinner.}

\item{timeout}{In milliseconds, time after the output has been regenerated for removing the loading state.}

\item{svgColor}{Changes the SVG Icons color. You can use HEX, RGB or RGBA.}

\item{svgSize}{Changes the SVG Icons width and height.}

\item{messageColor}{Changes the color of the message text.}

\item{messageFontSize}{Changes the font-size of the message text.}

\item{backgroundColor}{Changes the background color. You can use HEX, RGB or RGBA.}

\item{...}{Other options passed to the JavaScript method, see \href{https://notiflix.github.io/documentation}{this link}
for all available options.}
}
\value{
An HTML tag that you can use in Shiny UI.
}
\description{
Call this function once in your UI to automatically
add loading indicators to several outputs when they are being regenerated.
}
\note{
This function is experimental, if you encounter bugs or bad behavior,
please report \href{https://github.com/dreamRs/shinybusy/issues}{issue here}.
}
\examples{
library(shinybusy)
library(shiny)

ui <- fluidPage(

  # Use once in UI
  add_loading_state(
    ".shiny-plot-output",
    text = "Please wait...",
    svgColor = "steelblue"
  ),

  tags$h3("Loading state"),
  actionButton("refresh", "Refresh charts"),
  actionButton("modal", "Open modal window"),

  fluidRow(
    column(
      width = 6,
      plotOutput(outputId = "plot1")
    ),
    column(
      width = 6,
      plotOutput(outputId = "plot2")
    )
  )

)

server <- function(input, output, session) {

  output$plot1 <- renderPlot({
    input$refresh
    if (input$refresh > 0) {
      Sys.sleep(2)
    }
    barplot(table(floor(runif(100) * 6)))
  })

  output$plot2 <- renderPlot({
    input$refresh
    if (input$refresh > 0) {
      Sys.sleep(2)
    }
    plot(rnorm(50), rnorm(50))
  })


  observeEvent(input$modal, {
    showModal(modalDialog(
      title = "Works in modal too",
      actionButton("refresh2", "Refresh chart"),
      plotOutput(outputId = "plot3")
    ))
  })

  output$plot3 <- renderPlot({
    input$refresh2
    if (input$refresh2 > 0) {
      Sys.sleep(2)
    }
    hist(rnorm(500))
  })

}

if (interactive())
  shinyApp(ui, server)

}
