% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/busy-gif.R
\name{add_busy_gif}
\alias{add_busy_gif}
\title{Busy indicator (GIF)}
\usage{
add_busy_gif(src, timeout = 100, position = c("top-right", "top-left",
  "bottom-right", "bottom-left", "full-page", "free"), margins = c(10,
  10), overlay_color = "rgba(0, 0, 0, 0.5)", overlay_css = NULL,
  height = "50px", width = "50px")
}
\arguments{
\item{src}{Path to the GIF, an URL or a file in www/ folder.}

\item{timeout}{Number of milliseconds after the server is busy to display the Gif}

\item{position}{Where to display the spinner: \code{'top-right'}, \code{'top-left'}, \code{'bottom-right'},
\code{'bottom-left'}, \code{'full-page'}.}

\item{margins}{Distance from margins, a vector of length two, where first element is distance from top/bottom,
second element distance from right/left.}

\item{overlay_color}{Background color for the overlay if \code{position = "full-page"}.}

\item{overlay_css}{Additional CSS for the overlay, for example \code{"z-index: 1000;"} to make it appear of everything.}

\item{height, width}{Height and width of the spinner, default to \code{'50px'} for both, must be specified.}
}
\description{
Make a GIF play when server is busy and stop when idle.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinybusy)

  ui <- fluidPage(

    # Use this function somewhere in UI
    add_busy_gif(
      src = "https://jeroen.github.io/images/banana.gif",
      height = 70, width = 70
    ),

    actionButton("sleep", "Long calculation")
  )

  server <- function(input, output, session) {

    observeEvent(input$sleep, {
      Sys.sleep(5)
    })

  }

  shinyApp(ui, server)
}
}
