% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Button.R
\name{f7Button}
\alias{f7Button}
\alias{updateF7Button}
\alias{f7Segment}
\title{Framework7 action button}
\usage{
f7Button(
  inputId = NULL,
  label = NULL,
  href = NULL,
  color = NULL,
  fill = TRUE,
  outline = FALSE,
  shadow = FALSE,
  rounded = FALSE,
  size = NULL,
  active = FALSE,
  tonal = FALSE,
  icon = NULL
)

updateF7Button(
  inputId,
  label = NULL,
  color = NULL,
  fill = NULL,
  outline = NULL,
  shadow = NULL,
  rounded = NULL,
  size = NULL,
  tonal = NULL,
  icon = NULL,
  session = shiny::getDefaultReactiveDomain()
)

f7Segment(
  ...,
  container = deprecated(),
  shadow = FALSE,
  rounded = FALSE,
  strong = FALSE
)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{label}{The contents of the button or link–usually a text label,
but you could also use any other HTML, like an image or \link{f7Icon}.}

\item{href}{Button link.}

\item{color}{Button color. Not compatible with outline.
See here for valid colors \url{https://framework7.io/docs/badge.html}.}

\item{fill}{Fill style. TRUE by default. Not compatible with outline}

\item{outline}{Outline style. FALSE by default. Not compatible with fill.}

\item{shadow}{Button shadow. FALSE by default. Only for material design.}

\item{rounded}{Round style. FALSE by default.}

\item{size}{Button size. NULL by default but also "large" or "small".}

\item{active}{Button active state. Default to FALSE. This is useful when
used in \link{f7Segment} with the strong parameter set to TRUE.}

\item{tonal}{Button tonal style. Default to FALSE}

\item{icon}{Button icon. Expect \link{f7Icon}.}

\item{session}{The Shiny session object, usually the default value will suffice.}

\item{...}{Slot for \link{f7Button}.}

\item{container}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}:
removed from Framework7.}

\item{strong}{Add white background so that text is highlighted. FALSE by default.}
}
\description{
\code{f7Button} generates a Framework7 action button.

\code{updateF7Button} updates an \link{f7Button}.

A Framework7 segmented button container for \link{f7Button}.
}
\examples{
library(shiny)
library(shinyMobile)

app <- shiny::shinyApp(
  ui = f7Page(
    title = "Update f7Button",
    f7SingleLayout(
      navbar = f7Navbar(title = "Update f7Button"),
      f7Block(f7Button("update", "Update Button")),
      f7Block(
        f7Button(
          "button",
          "My button",
          color = "orange",
          outline = FALSE,
          fill = TRUE,
          shadow = FALSE,
          rounded = FALSE,
          icon = f7Icon("speedometer")
        )
      )
    )
  ),
  server = function(input, output, session) {
    observeEvent(input$update, {
      updateF7Button(
        inputId = "button",
        label = "Updated label",
        color = "purple",
        shadow = TRUE,
        rounded = TRUE,
        outline = TRUE,
        fill = FALSE,
        tonal = TRUE,
        size = "large",
        icon = f7Icon("speaker_zzz")
      )
    })
  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
if (interactive()) {
  library(shiny)
  library(shinyMobile)

  shinyApp(
    ui = f7Page(
      options = list(dark = FALSE),
      title = "Button Segments",
      f7SingleLayout(
        navbar = f7Navbar(title = "f7Segment, f7Button"),
        f7BlockTitle(title = "Simple Buttons in a segment"),
        f7Segment(
          f7Button(color = "blue", label = "My button", fill = FALSE),
          f7Button(color = "green", label = "My button", fill = FALSE),
          f7Button(color = "yellow", label = "My button", fill = FALSE)
        ),
        f7BlockTitle(title = "Tonal buttons"),
        f7Segment(
          f7Button(color = "blue", label = "My button", tonal = TRUE),
          f7Button(color = "green", label = "My button", tonal = TRUE),
          f7Button(color = "yellow", label = "My button", tonal = TRUE)
        ),
        f7BlockTitle(title = "Filled Buttons in a segment/rounded container"),
        f7Segment(
          rounded = TRUE,
          f7Button(color = "black", label = "My button"),
          f7Button(color = "green", label = "My button"),
          f7Button(color = "yellow", label = "My button")
        ),
        f7BlockTitle(title = "Outline Buttons in a segment/shadow container"),
        f7Segment(
          shadow = TRUE,
          f7Button(label = "My button", outline = TRUE, fill = FALSE),
          f7Button(label = "My button", outline = TRUE, fill = FALSE),
          f7Button(label = "My button", outline = TRUE, fill = FALSE)
        ),
        f7BlockTitle(title = "Buttons in a segment/strong container"),
        f7Segment(
          strong = TRUE,
          f7Button(label = "My button", fill = FALSE),
          f7Button(label = "My button", fill = FALSE),
          f7Button(label = "My button", fill = FALSE, active = TRUE)
        )
      )
    ),
    server = function(input, output) {}
  )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
