% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-update-inputs.R
\name{updateF7Select}
\alias{updateF7Select}
\title{Change the value of a select input on the client}
\usage{
updateF7Select(
  inputId,
  selected = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{The id of the input object.}

\item{selected}{New value.}

\item{session}{The Shiny session object, usually the default value will suffice.}
}
\description{
Change the value of a select input on the client
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
     title = "My app",
     f7SingleLayout(
       navbar = f7Navbar(title = "updateF7Select"),
       f7Card(
         f7Button(inputId = "update", label = "Update select"),
         br(),
         f7Select(
          inputId = "variable",
          label = "Choose a variable:",
          choices = colnames(mtcars)[-1],
          selected = "hp"
         ),
         verbatimTextOutput("test")
       )
     )
   ),
   server = function(input, output, session) {

     output$test <- renderPrint(input$variable)

     observeEvent(input$update, {
       updateF7Select(
         inputId = "variable",
         selected = "gear"
       )
     })
   }
 )
}
}
