% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Navbar.R
\name{f7NavbarHide}
\alias{f7NavbarHide}
\title{Hide a framework7 navbar}
\usage{
f7NavbarHide(
  session = shiny::getDefaultReactiveDomain(),
  animate = TRUE,
  hideStatusbar = FALSE
)
}
\arguments{
\item{session}{Shiny session object.}

\item{animate}{Whether it should be hidden with animation or not. By default is TRUE.}

\item{hideStatusbar}{When FALSE (default) it hides navbar partially keeping space
required to cover statusbar area. Otherwise, navbar will be fully hidden.}
}
\description{
Hide a framework7 navbar
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
    ui = f7Page(
       title = "Accordions",
       f7SingleLayout(
          navbar = f7Navbar("Hide/Show navbar"),
          f7Segment(
             f7Button(inputId = "hide", "Hide navbar", color = "red"),
             f7Button(inputId = "show", "Show navbar", color = "green"),
          )
       )
    ),
    server = function(input, output, session) {

       observeEvent(input$hide, {
          f7NavbarHide()
       })

       observeEvent(input$show, {
          f7NavbarShow()
       })
    }
 )
}
}
