% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/null_aggregator.R
\docType{class}
\name{null_aggregator}
\alias{null_aggregator}
\title{NULL aggregator.}
\format{
An \code{R6::R6Class} object
}
\description{
It does not aggregate the data but returns the full samples within the range.
}
\examples{
data(noise_fluct)
agg <- null_aggregator$new()
d_agg <- agg$aggregate(noise_fluct$sec, noise_fluct$level)
plot(d_agg$x[1:100], d_agg$y[1:100], type = "l")
}
\section{Super class}{
\code{\link[shinyHugePlot:aggregator]{shinyHugePlot::aggregator}} -> \code{null_aggregator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-null_aggregator-new}{\code{null_aggregator$new()}}
\item \href{#method-null_aggregator-aggregate}{\code{null_aggregator$aggregate()}}
\item \href{#method-null_aggregator-clone}{\code{null_aggregator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-null_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-null_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor that changes nothing.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{null_aggregator$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{not used}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-null_aggregator-aggregate"></a>}}
\if{latex}{\out{\hypertarget{method-null_aggregator-aggregate}{}}}
\subsection{Method \code{aggregate()}}{
Function where no aggregation will be executed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{null_aggregator$aggregate(x, y, n_out = -1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x, y}}{Vectors.}

\item{\code{n_out}}{Integer, omitted.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-null_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-null_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{null_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
