% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abstract_downsampler.R
\docType{class}
\name{abstract_downsampler}
\alias{abstract_downsampler}
\title{R6 abstract class for down-sampling}
\format{
An \code{R6::R6Class} object
}
\description{
An abstract class for the down-sampler,
which defines the structure of the class and
is not available on a stand-alone basis.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{figure}}{plotly object.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-abstract_downsampler-new}{\code{abstract_downsampler$new()}}
\item \href{#method-abstract_downsampler-add_trace}{\code{abstract_downsampler$add_trace()}}
\item \href{#method-abstract_downsampler-get_figure_data}{\code{abstract_downsampler$get_figure_data()}}
\item \href{#method-abstract_downsampler-get_orig_data}{\code{abstract_downsampler$get_orig_data()}}
\item \href{#method-abstract_downsampler-set_orig_data}{\code{abstract_downsampler$set_orig_data()}}
\item \href{#method-abstract_downsampler-clone}{\code{abstract_downsampler$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-abstract_downsampler-new"></a>}}
\if{latex}{\out{\hypertarget{method-abstract_downsampler-new}{}}}
\subsection{Method \code{new()}}{
Constructing an abstract down-sampler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{abstract_downsampler$new(
  figure = plotly::plot_ly(),
  is_downsample = TRUE,
  n_out = 1000L,
  aggregator = eLTTB_aggregator$new(),
  legend_options = list(downsample_prefix = "<b style=\\"color:sandybrown\\">[R]</b> ",
    downsample_suffix = "", is_aggsize_shown = TRUE, agg_prefix =
    "<i style=\\"color:#fc9944\\"> ~", agg_suffix = "</i>"),
  tz = Sys.timezone()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{figure}}{Plotly structure that will be down-sampled.}

\item{\code{is_downsample}}{Boolean.
Whether down-sampling is done. By default \code{TRUE}.}

\item{\code{n_out}}{Integer or numeric.
The number of samples shown after down-sampling. By default 1000.}

\item{\code{aggregator}}{An instance of an R6 class for aggregation.
Select an aggregation function. The list of the functions are obtained
using \code{list_aggregators}.
By default, \code{eLTTB_aggregator$new()}.}

\item{\code{legend_options}}{Named list, optional.
Names of the elements are \code{prefix_downsample},
\code{suffix_downsample}, \code{is_aggsize_shown}, \code{agg_prefix},
and \code{agg_suffix}.
The \code{prefix_downsample} and \code{suffix_downsample}
will be added to the legend name when the traces are down-sampled.
By default, prefix is a bold orange \code{[R]} and suffix is none.
The \code{is_aggsize_shown} is boolean.
Whether the mean aggregation bin size will be added to the legend name.
By default \code{TRUE}.
The \code{agg_prefix} and \code{agg_suffix} are employed to show
the mean aggregation size}

\item{\code{tz}}{Character, optional.
Time zone used to display time-series data.
By default \code{Sys.timezone()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-abstract_downsampler-add_trace"></a>}}
\if{latex}{\out{\hypertarget{method-abstract_downsampler-add_trace}{}}}
\subsection{Method \code{add_trace()}}{
Adds a trace to the figure (\code{self$figure}) and returns nothing.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{abstract_downsampler$add_trace(
  ...,
  n_out = NULL,
  aggregator = NULL,
  hf_x = NULL,
  hf_y = NULL,
  hf_text = NULL,
  hf_hovertext = NULL,
  tz = Sys.timezone()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments passed along to the plotly trace.
(e.g., \code{id}, \code{x}, \code{y},
\code{data}, \code{type}, \code{mode}).}

\item{\code{n_out}}{Integer, optional.
The max number of samples that are shown in the figure.
By default, \code{private$n_out_default}.}

\item{\code{aggregator}}{An instance of an R6 class for aggregation.
The aggregator used for downsampling.
By default, \code{private$aggregator_default}.}

\item{\code{hf_x, hf_y, hf_text, hf_hovertext}}{Optional.
The original high frequency data for \code{x}, \code{y},
\code{text} and \code{hovertext}.}

\item{\code{tz}}{Character, optional.
The timezone used in the plotly. By default, \code{Sys.timezone()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-abstract_downsampler-get_figure_data"></a>}}
\if{latex}{\out{\hypertarget{method-abstract_downsampler-get_figure_data}{}}}
\subsection{Method \code{get_figure_data()}}{
Returns the list of the data used for the plotly figure.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{abstract_downsampler$get_figure_data()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-abstract_downsampler-get_orig_data"></a>}}
\if{latex}{\out{\hypertarget{method-abstract_downsampler-get_orig_data}{}}}
\subsection{Method \code{get_orig_data()}}{
Returns the list of the original data and aggregators.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{abstract_downsampler$get_orig_data(uid = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uid}}{Character, optional.
If it is given, the data of the \code{uid} will be returned}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-abstract_downsampler-set_orig_data"></a>}}
\if{latex}{\out{\hypertarget{method-abstract_downsampler-set_orig_data}{}}}
\subsection{Method \code{set_orig_data()}}{
Set the original data.
If there is an existing data, replace with the new one.
If not, add new data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{abstract_downsampler$set_orig_data(
  uid,
  name = NULL,
  data = NULL,
  axis_type = NULL,
  n_out = NULL,
  aggregator = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uid}}{Character.
Unique id to identify the original data.}

\item{\code{name}}{Character, optional.
Name of the data that will be used as the trace legend.}

\item{\code{data}}{Data frame, optional.
Original data. \code{x} and \code{y} columns should be included.}

\item{\code{axis_type}}{Character, optional.
\code{linear} or \code{date}, depending on the \code{x} value.}

\item{\code{n_out}}{Integer, optional.
Number of samples that are displayed.}

\item{\code{aggregator}}{An R6 class instance for aggregation.
Select an aggregation function. The list of the functions are obtained
using \code{list_aggregators}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-abstract_downsampler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-abstract_downsampler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{abstract_downsampler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
