


#' show toast message
#'
#' A wrapper around the `toastr` JavaScript library that uses our preferred default argument
#' values.
#'
#' @param type length 1 character vector.  Valid values are "success", "error", "warning", and "info"
#' @param message the toast message
#' @param title the toast title.  Defaults to \code{NULL}
#' @param .options other options to pass to the \code{toastr} JavaScript library.  See 
#' \url{https://codeseven.github.io/toastr/demo.html} for a full demo of options.
#' @param session the Shiny session.  Defaults to \code{shiny::getDefaultReactiveDomain()}.
#'
#' @export
#'
#' @importFrom shiny getDefaultReactiveDomain
#'
#' @return `invisible()`
#'
showToast <- function(
  type, 
  message,
  title = NULL,
  .options = list(
    positionClass = "toast-bottom-center",
    progressBar = TRUE,
    timeOut = 4000,
    closeButton = TRUE,
    
    # same as defaults
    newestOnTop = FALSE,
    preventDuplicates = FALSE,
    showDuration = 300,
    hideDuration = 1000,
    extendedTimeOut = 1000,
    showEasing = "swing",
    hideEasing = "swing",
    showMethod = "fadeIn",
    hideMethod = "fadeOut"
  ), 
  session = shiny::getDefaultReactiveDomain()
) {

  session$sendCustomMessage(
    type = "toastr",
    message = list(
      'type' = type,
      'message' = message,
      'title' = title,
      'options' = .options
    )
  )
  
  invisible()
}

