% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renders.R, R/source_tblist.R
\name{rendering-filters}
\alias{rendering-filters}
\alias{.render_filters}
\alias{.render_filters.default}
\alias{.render_filters.tblist}
\title{Render filtering panels for all the filters included in Cohort}
\usage{
.render_filters(source, ...)

\method{.render_filters}{default}(source, cohort, step_id, ns, ...)

\method{.render_filters}{tblist}(source, cohort, step_id, ns, ...)
}
\arguments{
\item{source}{Source object.}

\item{...}{Extra arguments passed to a specific method.}

\item{cohort}{Cohort object.}

\item{step_id}{Id of the step.}

\item{ns}{Namespace function.}
}
\value{
Nested list of `shiny.tag` objects storing html structure of filter input panels.
}
\description{
The method exported only for custom extensions use.
}
\details{
Within the method you should define source data stats output (see \link{.update_data_stats}),
and define a loop that renders filtering panel for each filter (using \link{.render_filter}).
}
\examples{
if (interactive()) {
  library(magrittr)
  library(shiny)
  library(cohortBuilder)
  library(shinyCohortBuilder)

  ui <- fluidPage(
    actionButton("add_filter", "Add Filter"),
    div(id = "filter_container")
  )

  server <- function(input, output, session) {
    add_gui_filter_layer <- function(public, private, ...) {
      private$steps[["1"]]$filters$copies$gui <- .gui_filter(
        private$steps[["1"]]$filters$copies
      )
      private$steps[["1"]]$filters$registered$gui <- .gui_filter(
        private$steps[["1"]]$filters$registered
      )
    }
    add_hook("post_cohort_hook", add_gui_filter_layer)
    coh <- cohort(
      set_source(as.tblist(librarian)),
      filter(
        "range", id = "copies", name = "Copies", dataset = "books",
        variable = "copies", range = c(5, 12)
      ),
      filter(
        "date_range", id = "registered", name = "Registered",  dataset = "borrowers",
        variable = "registered", range = c(as.Date("2010-01-01"), Inf)
      )
    ) \%>\% run()
    coh$attributes$session <- session
    coh$attributes$feedback <- TRUE

    observeEvent(input$add_filter, {
      insertUI(
        "#filter_container",
        ui = .render_filters(
          coh$get_source(),
          cohort = coh,
          step_id = "1",
          ns = function(x) x
        ))
    }, ignoreInit = TRUE, once = TRUE)
  }

  shinyApp(ui, server)
}
}
\seealso{
\link{source-gui-layer}
}
