% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chakraDrawer.R
\name{chakraDrawer}
\alias{chakraDrawer}
\title{Drawer widget}
\usage{
chakraDrawer(
  inputId,
  openButton,
  options = chakraDrawerOptions(),
  isOpen = FALSE,
  closeButton = TRUE,
  header,
  body,
  footer
)
}
\arguments{
\item{inputId}{widget id}

\item{openButton}{a Chakra button to open the drawer}

\item{options}{list of options created with \code{\link{chakraDrawerOptions}}}

\item{isOpen}{Boolean, whether the drawer is initially open}

\item{closeButton}{Boolean, whether to include a closing button}

\item{header}{a \code{DrawerHeader} element}

\item{body}{a \code{DrawerBody} element}

\item{footer}{a \code{DrawerFooter} element}
}
\value{
A widget to use in \code{\link{chakraComponent}}.
}
\description{
Create a drawer widget, a panel that slides out from the edge
  of the screen.
}
\details{
Similarly to \code{\link{chakraAlertDialog}}, you can set an
  action attribute and a value attribute to the Chakra buttons you include
  in the Chakra drawer.
}
\examples{
library(shiny)
library(shinyChakraUI)

ui <- chakraPage(

  br(),

  chakraComponent(
    "mycomponent",

    chakraDrawer(
      "drawer",
      openButton = Tag$Button("Open Drawer"),
      options = chakraDrawerOptions(placement = "right"),
      header = Tag$DrawerHeader("I'm the header"),
      body = Tag$DrawerBody(
        Tag$Box("I'm the body")
      ),
      footer = Tag$DrawerFooter(
        Tag$ButtonGroup(
          spacing = "6",
          Tag$Button(
            value = "try me",
            "Try me"
          ),
          Tag$Button(
            action = "close",
            variant = "outline",
            "Close"
          )
        )
      )
    )

  )

)

server <- function(input, output, session){

  observe({
    print(input[["drawer"]])
  })

}

if(interactive()){
  shinyApp(ui, server)
}
}
