% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-storage-mongodb.R
\name{DataStorageMongoDB}
\alias{DataStorageMongoDB}
\title{Data storage class with MongoDB provider}
\description{
Implementation of the \code{\link{DataStorage}} R6 class to MongoDB backend using a
unified API for read/write operations
}
\examples{
\dontrun{
data_storage <- DataStorageMongoDB$new(
  host = "localhost",
  db = "test",
  ssl_options = mongolite::ssl_options()
)
data_storage$insert("example", "test_event", "session1")
data_storage$insert("example", "input", "s1", list(id = "id1"))
data_storage$insert("example", "input", "s1", list(id = "id2", value = 32))

data_storage$insert(
  "example", "test_event_3_days_ago", "session1",
  time = lubridate::as_datetime(lubridate::today() - 3)
)

data_storage$read_event_data()
data_storage$read_event_data(Sys.Date() - 1, Sys.Date() + 1)
data_storage$close()
}
}
\section{Super class}{
\code{\link[shiny.telemetry:DataStorage]{shiny.telemetry::DataStorage}} -> \code{DataStorageMongoDB}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataStorageMongoDB-new}{\code{DataStorageMongoDB$new()}}
\item \href{#method-DataStorageMongoDB-clone}{\code{DataStorageMongoDB$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shiny.telemetry" data-topic="DataStorage" data-id="close"><a href='../../shiny.telemetry/html/DataStorage.html#method-DataStorage-close'><code>shiny.telemetry::DataStorage$close()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shiny.telemetry" data-topic="DataStorage" data-id="insert"><a href='../../shiny.telemetry/html/DataStorage.html#method-DataStorage-insert'><code>shiny.telemetry::DataStorage$insert()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shiny.telemetry" data-topic="DataStorage" data-id="read_event_data"><a href='../../shiny.telemetry/html/DataStorage.html#method-DataStorage-read_event_data'><code>shiny.telemetry::DataStorage$read_event_data()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStorageMongoDB-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataStorageMongoDB-new}{}}}
\subsection{Method \code{new()}}{
Initialize the data storage class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStorageMongoDB$new(
  hostname = "localhost",
  port = 27017,
  username = NULL,
  password = NULL,
  authdb = NULL,
  dbname = "shiny_telemetry",
  options = NULL,
  ssl_options = mongolite::ssl_options()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hostname}}{the hostname or IP address of the MongoDB server.}

\item{\code{port}}{the port number of the MongoDB server (default is 27017).}

\item{\code{username}}{the username for authentication (optional).}

\item{\code{password}}{the password for authentication (optional).}

\item{\code{authdb}}{the default authentication database (optional).}

\item{\code{dbname}}{name of database (default is "shiny_telemetry").}

\item{\code{options}}{Additional connection options in a named list format
(e.g., list(ssl = "true", replicaSet = "myreplicaset")) (optional).}

\item{\code{ssl_options}}{additional connection options such as SSL keys/certs
(default is \code{\link[mongolite:ssl_options]{mongolite::ssl_options()}}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStorageMongoDB-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DataStorageMongoDB-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStorageMongoDB$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
