% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-storage.R
\name{DataStorage}
\alias{DataStorage}
\title{Data Storage abstract class to handle all the read/write operations}
\description{
Abstract R6 Class that encapsulates all the operations needed by
Shiny.telemetry to read and write. This removes the complexity from the
functions and uses a unified API.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{event_bucket}}{string that identifies the bucket to store user
related and action data}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataStorage-new}{\code{DataStorage$new()}}
\item \href{#method-DataStorage-insert}{\code{DataStorage$insert()}}
\item \href{#method-DataStorage-read_event_data}{\code{DataStorage$read_event_data()}}
\item \href{#method-DataStorage-close}{\code{DataStorage$close()}}
\item \href{#method-DataStorage-clone}{\code{DataStorage$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStorage-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataStorage-new}{}}}
\subsection{Method \code{new()}}{
initialize data storage object common with all providers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStorage$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStorage-insert"></a>}}
\if{latex}{\out{\hypertarget{method-DataStorage-insert}{}}}
\subsection{Method \code{insert()}}{
Insert new data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStorage$insert(app_name, type, session = NULL, details = NULL, time = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{app_name}}{string with name of dashboard (the version can be also
included in this string)}

\item{\code{type}}{string that identifies the event type to store}

\item{\code{session}}{(optional) string that identifies a session where the
event was logged}

\item{\code{details}}{atomic element of list with data to save in storage}

\item{\code{time}}{date time value indicates the moment the record was
generated in UTC. By default it should be NULL and determined
automatically, but in cases where it should be defined, use `Sys.time()`
or `lubridate::now(tzone = "UTC")` to generate it.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing. This method is called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStorage-read_event_data"></a>}}
\if{latex}{\out{\hypertarget{method-DataStorage-read_event_data}{}}}
\subsection{Method \code{read_event_data()}}{
read all user data from SQLite.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStorage$read_event_data(date_from = NULL, date_to = NULL, app_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{date_from}}{(optional) date representing the starting day of
results.}

\item{\code{date_to}}{(optional) date representing the last day of results.}

\item{\code{app_name}}{(optional) string identifying the Dashboard-specific event
data}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStorage-close"></a>}}
\if{latex}{\out{\hypertarget{method-DataStorage-close}{}}}
\subsection{Method \code{close()}}{
Close the connection if necessary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStorage$close()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStorage-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DataStorage-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStorage$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
