% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toaster.R
\name{Toaster}
\alias{Toaster}
\title{Toaster}
\description{
Documentation: \url{https://blueprintjs.com/docs/#core/components/toast}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Toaster-new}{\code{Toaster$new()}}
\item \href{#method-Toaster-show}{\code{Toaster$show()}}
\item \href{#method-Toaster-clear}{\code{Toaster$clear()}}
\item \href{#method-Toaster-dismiss}{\code{Toaster$dismiss()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Toaster-new"></a>}}
\if{latex}{\out{\hypertarget{method-Toaster-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Toaster$new(
  toasterId = incrementToasterId(),
  session = shiny::getDefaultReactiveDomain(),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{toasterId}}{Unique number - needed to use more than one toaster}

\item{\code{session}}{Shiny session object}

\item{\code{...}}{Parameters passed to \code{Toaster} component}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Toaster} instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Toaster-show"></a>}}
\if{latex}{\out{\hypertarget{method-Toaster-show}{}}}
\subsection{Method \code{show()}}{
Shows a new toast to the user, or updates an existing toast
corresponding to the provided key
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Toaster$show(..., key = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Parameters passed to \code{Toaster} component}

\item{\code{key}}{A key of toast to be shown/dismissed}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing. This method is called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Toaster-clear"></a>}}
\if{latex}{\out{\hypertarget{method-Toaster-clear}{}}}
\subsection{Method \code{clear()}}{
Dismiss all toasts instantly
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Toaster$clear()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing. This method is called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Toaster-dismiss"></a>}}
\if{latex}{\out{\hypertarget{method-Toaster-dismiss}{}}}
\subsection{Method \code{dismiss()}}{
Dismiss the given toast instantly
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Toaster$dismiss(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{A key of toast to be shown/dismissed}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing. This method is called for side effects.
}
}
}
