#' sheldusr - Natural disaster losses for the USA from the SHELDUS database
#'
#' The Spatial Hazard Events and Losses Database in the United States 
#' (SHELDUS, http://www.sheldus.org), from the University of South Carolina, 
#' is a database on human and property losses from natural disasters 
#' in the United States. 
#' 
#' Data from this database includes County-level information on property losses, 
#' crop losses, injuries and fatalities from 18 different types of natural 
#' hazards (hurricanes, droughts, floods, etc.) from about 1960 to the present. 
#' 
#' Although the data is free, downloading the data is tedious and so is 
#' cleaning and analysing it. In this package latest data from the SHELDUS 
#' database was packaged compactly for easy access through R.
#' 
#' @references Hazards & Vulnerability Research Institute (2013). 
#' The Spatial Hazard Events and Losses Database for the United States, 
#' Version 12.0 [Online Database]. Columbia, SC: University of South Carolina. 
#' Available from http://www.sheldus.org
#' 
#' @name sheldusr
#' @docType package
NULL
