% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{CheckParamRegression}
\alias{CheckParamRegression}
\title{Checking input parameters (regression model)}
\usage{
CheckParamRegression(
  Lambda = NULL,
  pi_list = seq(0.6, 0.9, by = 0.01),
  K = 100,
  tau = 0.5,
  seed = 1,
  n_cat = NULL,
  family = "gaussian",
  implementation = PenalisedRegression,
  resampling = "subsampling",
  PFER_method = "MB",
  PFER_thr = Inf,
  FDP_thr = Inf,
  Lambda_cardinal = 100,
  verbose = TRUE
)
}
\arguments{
\item{Lambda}{matrix of parameters controlling the level of sparsity in the
underlying feature selection algorithm specified in \code{implementation}.
If \code{Lambda=NULL} and \code{implementation=PenalisedRegression},
\code{\link{LambdaGridRegression}} is used to define a relevant grid.}

\item{pi_list}{vector of thresholds in selection proportions. If
\code{n_cat=NULL} or \code{n_cat=2}, these values must be \code{>0} and
\code{<1}. If \code{n_cat=3}, these values must be \code{>0.5} and
\code{<1}.}

\item{K}{number of resampling iterations.}

\item{tau}{subsample size. Only used if \code{resampling="subsampling"} and
\code{cpss=FALSE}.}

\item{seed}{value of the seed to initialise the random number generator and
ensure reproducibility of the results (see \code{\link[base]{set.seed}}).}

\item{n_cat}{computation options for the stability score. Default is
\code{NULL} to use the score based on a z test. Other possible values are 2
or 3 to use the score based on the negative log-likelihood.}

\item{family}{type of regression model. This argument is defined as in
\code{\link[glmnet]{glmnet}}. Possible values include \code{"gaussian"}
(linear regression), \code{"binomial"} (logistic regression),
\code{"multinomial"} (multinomial regression), and \code{"cox"} (survival
analysis).}

\item{implementation}{function to use for variable selection. Possible
functions are: \code{PenalisedRegression}, \code{SparsePLS},
\code{GroupPLS} and \code{SparseGroupPLS}. Alternatively, a user-defined
function can be provided.}

\item{resampling}{resampling approach. Possible values are:
\code{"subsampling"} for sampling without replacement of a proportion
\code{tau} of the observations, or \code{"bootstrap"} for sampling with
replacement generating a resampled dataset with as many observations as in
the full sample. Alternatively, this argument can be a function to use for
resampling. This function must use arguments named \code{data} and
\code{tau} and return the IDs of observations to be included in the
resampled dataset.}

\item{PFER_method}{method used to compute the upper-bound of the expected
number of False Positives (or Per Family Error Rate, PFER). If
\code{PFER_method="MB"}, the method proposed by Meinshausen and Bühlmann
(2010) is used. If \code{PFER_method="SS"}, the method proposed by Shah and
Samworth (2013) under the assumption of unimodality is used.}

\item{PFER_thr}{threshold in PFER for constrained calibration by error
control. If \code{PFER_thr=Inf} and \code{FDP_thr=Inf}, unconstrained
calibration is used (the default).}

\item{FDP_thr}{threshold in the expected proportion of falsely selected
features (or False Discovery Proportion) for constrained calibration by
error control. If \code{PFER_thr=Inf} and \code{FDP_thr=Inf}, unconstrained
calibration is used (the default).}

\item{Lambda_cardinal}{number of values in the grid of parameters controlling
the level of sparsity in the underlying algorithm. Only used if
\code{Lambda=NULL}.}

\item{verbose}{logical indicating if a loading bar and messages should be
printed.}
}
\description{
Checks if input parameters are valid. For invalid parameters, this function
(i) stops the run and generates an error message, or (ii) sets the invalid
parameter to its default value and reports it in a warning message.
}
\keyword{internal}
