% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_energy.R
\name{calculate_energy}
\alias{calculate_energy}
\title{calculate_energy}
\usage{
calculate_energy(pattern, return_mean = FALSE, method = "spatial",
  comp_fast = 1000, verbose = TRUE)
}
\arguments{
\item{pattern}{List with reconstructed patterns.}

\item{return_mean}{Return the mean energy.}

\item{method}{String to specifiy if spatial pattern or marks were reconstructed.}

\item{comp_fast}{If pattern contains more points than threshold, summary functions are estimated in a computational fast way.}

\item{verbose}{Print progress report.}
}
\value{
numeric
}
\description{
Calculate mean energy
}
\details{
The function calculates the mean energy (or deviation) between the observed
pattern and all reconstructed patterns (for more information see Tscheschel &
Stoyan (2006) or Wiegand & Moloney (2014)). The pair correlation function and the
nearest neighbour distance function are used to describe the patterns. For large
patterns `comp_fast = TRUE` decreases the computational demand because no edge
correction is used and the pair correlation function is estimated based on Ripley's
K-function. For more information see \code{\link{estimate_pcf_fast}}.
}
\examples{
pattern_random <- fit_point_process(species_a, n_random = 19)
calculate_energy(pattern_random)
calculate_energy(pattern_random, return_mean = TRUE)

\dontrun{
marks_sub <- spatstat::subset.ppp(species_a, select = dbh)
marks_recon <- reconstruct_marks(pattern_random[[1]], marks_sub, n_random = 19, max_runs = 1000)
calculate_energy(marks_recon, return_mean = FALSE, method = "marks")
}

}
\references{
Tscheschel, A., & Stoyan, D. (2006). Statistical reconstruction of random point
patterns. Computational Statistics and Data Analysis, 51(2), 859–871.

Wiegand, T., & Moloney, K. A. (2014). Handbook of spatial point-pattern analysis
in ecology. Boca Raton: Chapman and Hall/CRC Press.
}
\seealso{
\code{\link{reconstruct_pattern}} \cr
\code{\link{plot_randomized_pattern}}
}
