% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVF.R
\docType{methods}
\name{SVF}
\alias{SVF}
\alias{SVF,SpatialPoints-method}
\alias{SVF,Raster-method}
\title{Sky View Factor (SVF) calculation}
\usage{
\S4method{SVF}{SpatialPoints}(location, obstacles, obstacles_height_field,
  res_angle = 5, b = 0.01, messages = TRUE,
  parallel = getOption("mc.cores"))

\S4method{SVF}{Raster}(location, obstacles, obstacles_height_field,
  res_angle = 5, b = 0.01, messages = TRUE,
  parallel = getOption("mc.cores"))
}
\arguments{
\item{location}{A \code{SpatialPoints*} or \code{Raster*} object, specifying the location(s) for which to calculate SVF}

\item{obstacles}{A \code{SpatialPolygonsDataFrame} object specifying the obstacles outline}

\item{obstacles_height_field}{Name of attribute in \code{obstacles} with extrusion height for each feature}

\item{res_angle}{Circular sampling resolution, in decimal degrees. Default is 5 degrees, i.e. 0, 5, 10... 355.}

\item{b}{Buffer size when joining intersection points with building outlines, to determine intersection height}

\item{messages}{Whether a message regarding distance units of the CRS should be displayed}

\item{parallel}{Number of parallel processes or a predefined socket cluster. With \code{parallel = 1} uses ordinary, non-parallel processing. The parallel processing is done with the \code{parallel} package}
}
\value{
A numeric value between 0 (sky completely obstructed) and 1 (sky completely visible).
\itemize{
\item{If input \code{location} is a \code{SpatialPoints*}, then returned object is a \code{vector} elements representing spatial locations (\code{location} features).}
\item{If input \code{location} is a \code{Raster*}, then returned object is a \code{RasterLayer} representing the SVF surface.}
}
}
\description{
Calculates the Sky View Factor (SVF) at given points or complete grid (\code{location}), taking into account obstacles outline (\code{obstacles}) given by a polygonal layer with a height attribute (\code{obstacles_height_field}).
}
\examples{
# Individual locations
data(rishon)
location0 = rgeos::gCentroid(rishon)
location1 = raster::shift(location0, 0, -15)
location2 = raster::shift(location0, -10, 20)
locations = rbind(location1, location2)
svfs = SVF(
  location = locations,
  obstacles = rishon,
  obstacles_height_field = "BLDG_HT"
)
plot(rishon)
plot(locations, add = TRUE)
raster::text(locations, round(svfs, 2), col = "red", pos = 3)

\dontrun{

# Grid
ext = as(raster::extent(rishon), "SpatialPolygons")
r = raster::raster(ext, res = 5)
proj4string(r) = proj4string(rishon)
pnt = raster::rasterToPoints(r, spatial = TRUE)
svfs = SVF(
    location = r,
    obstacles = rishon,
    obstacles_height_field = "BLDG_HT",
    parallel = 3
  )
plot(svfs, col = grey(seq(0.9, 0.2, -0.01)))
raster::contour(svfs, add = TRUE)
plot(rishon, add = TRUE, border = "red")

}

}
