% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVF.R
\name{SVF}
\alias{SVF}
\title{Sky View Factor (SVF) calculation}
\usage{
SVF(location, build, height_field, res = 5, b = 0.01)
}
\arguments{
\item{location}{A \code{SpatialPoints*} object specifying the location for which to calculate shade height}

\item{build}{A \code{SpatialPolygonsDataFrame} object specifying the buildings outline.}

\item{height_field}{The name of the column with building height in \code{build}}

\item{res}{Circular sampling resolution, in decimal degrees. Default is 5 degrees, i.e. 0, 5, 10... 355.}

\item{b}{Buffer size when joining intersection points with building outlines, to determine intersection height.}
}
\value{
A numeric value between 0 (sky completely obstructed) and 1 (sky completely visible).
}
\description{
Calculates the Sky View Factor (SVF) at a given location, given extruded obstacles (usually a buildings layer).
}
\examples{
data(build)
location0 = rgeos::gCentroid(build)
svf = SVF(location0, build, "BLDG_HT")
location1 = raster::shift(location0, 0, -15)
svf1 =  SVF(location1, build, "BLDG_HT")
location2 = raster::shift(location0, -10, 20)
svf2 =  SVF(location2, build, "BLDG_HT")

plot(build)
plot(location0, add = TRUE)
plot(location1, add = TRUE)
plot(location2, add = TRUE)
raster::text(location0, round(svf, 2), pos = 3)
raster::text(location1, round(svf1, 2), pos = 4)
raster::text(location2, round(svf2, 2), pos = 3)

}

