% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_clhs.R
\name{sample_clhs}
\alias{sample_clhs}
\title{Conditioned Latin Hypercube Sampling}
\usage{
sample_clhs(
  mraster,
  nSamp,
  iter = 10000,
  cost = NULL,
  existing = NULL,
  access = NULL,
  buff_inner = NULL,
  buff_outer = NULL,
  plot = FALSE,
  details = FALSE,
  filename = NULL,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{mraster}{spatRaster. ALS metrics raster.}

\item{nSamp}{Numeric. Number of desired samples.}

\item{iter}{Numeric. Value giving the number of iterations within the Metropolis-Hastings process.}

\item{cost}{Numeric/Character. Index or name of covariate within \code{mraster} to be used to constrain cLHS sampling.
If default (\code{NULL}), a cost constraint is not used.}

\item{existing}{sf 'POINT'.  Existing plot network.}

\item{access}{sf 'LINESTRING' or 'MULTILINESTRING'. Access network.}

\item{buff_inner}{Numeric. Inner buffer boundary specifying distance
from access where plots cannot be sampled.}

\item{buff_outer}{Numeric. Outer buffer boundary specifying distance
from access where plots can be sampled.}

\item{plot}{Logical. Plots output strata raster with samples.}

\item{details}{Logical. If \code{FALSE} (default) output is only
stratification raster. If \code{TRUE} return a list where \code{$details} is additional 
stratification information and \code{$raster} is the output stratification spatRaster.}

\item{filename}{Character. Path to write output samples.}

\item{overwrite}{Logical. Choice to overwrite existing \code{filename} if it exists.}

\item{...}{Additional arguments for clhs sampling. See \code{\link[clhs]{clhs}}.}
}
\value{
An sf object with \code{nSamp} stratified samples.
}
\description{
Conditioned Latin Hypercube Sampling using \code{\link[clhs]{clhs}} functionality.
}
\examples{
#--- Load raster and existing plots---#
r <- system.file("extdata", "mraster.tif", package = "sgsR")
mr <- terra::rast(r)

e <- system.file("extdata", "existing.shp", package = "sgsR")
e <- sf::st_read(e)

a <- system.file("extdata", "access.shp", package = "sgsR")
ac <- sf::st_read(a)

sample_clhs(
  mraster = mr,
  nSamp = 200,
  plot = TRUE,
  iter = 100
)

sample_clhs(
  mraster = mr,
  nSamp = 400,
  existing = e,
  iter = 250,
  details = TRUE
)

}
\references{
Minasny, B. and McBratney, A.B. 2006. A conditioned Latin hypercube method
for sampling in the presence of ancillary information. Computers and
Geosciences, 32:1378-1388.

Minasny, B. and A. B. McBratney, A.B.. 2010. Conditioned Latin Hypercube
Sampling for Calibrating Soil Sensor Data to Soil Properties. In: Proximal
Soil Sensing, Progress in Soil Science, pages 111-119.

Roudier, P., Beaudette, D.E. and Hewitt, A.E. 2012. A conditioned Latin
hypercube sampling algorithm incorporating operational constraints. In:
Digital Soil Assessments and Beyond. Proceedings of the 5th Global Workshop
on Digital Soil Mapping, Sydney, Australia.
}
\seealso{
Other sample functions: 
\code{\link{sample_ahels}()},
\code{\link{sample_balanced}()},
\code{\link{sample_nc}()},
\code{\link{sample_srs}()},
\code{\link{sample_strat}()},
\code{\link{sample_systematic}()}
}
\author{
Tristan R.H. Goodbody
}
\concept{sample functions}
