% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgl_cv.R
\name{sgl_cv}
\alias{sgl_cv}
\title{Generic sparse group lasso cross validation using multiple possessors}
\usage{
sgl_cv(module_name, PACKAGE, data, parameterGrouping = NULL,
  groupWeights = NULL, parameterWeights = NULL, alpha, lambda, d = 100,
  compute_lambda = length(lambda) == 1, fold = 2, sampleGroups = NULL,
  cv.indices = list(), responses = NULL, max.threads = NULL,
  use_parallel = FALSE, algorithm.config = sgl.standard.config)
}
\arguments{
\item{module_name}{reference to objective specific C++ routines.}

\item{PACKAGE}{name of the calling package.}

\item{data}{a list of data objects -- will be parsed to the specified module.}

\item{parameterGrouping}{grouping of parameters, a vector of length \eqn{p}.
Each element of the vector specifying the group of the parameters in the corresponding column of \eqn{\beta}.}

\item{groupWeights}{the group weights, a vector of length \code{length(unique(parameterGrouping))} (the number of groups).}

\item{parameterWeights}{a matrix of size \eqn{q \times p}.}

\item{alpha}{the \eqn{\alpha} value 0 for group lasso, 1 for lasso, between 0 and 1 gives a sparse group lasso penalty.}

\item{lambda}{lambda.min relative to lambda.max (if \code{compute_lambda = TRUE}) or the lambda sequence for the regularization path,
a vector or a list of vectors (of the same length) with the lambda sequence for the subsamples.}

\item{d}{length of lambda sequence (ignored if \code{compute_lambda = FALSE})}

\item{compute_lambda}{should the lambda sequence be computed}

\item{fold}{the fold of the cross validation, an integer larger than \eqn{1} and less than \eqn{N+1}.
Ignored if \code{cv.indices != NULL}.
If \code{fold}\eqn{\le}\code{max(table(classes))} then the data will be split into \code{fold} disjoint subsets keeping the ration of classes approximately equal.
Otherwise the data will be split into \code{fold} disjoint subsets without keeping the ration fixed.}

\item{sampleGroups}{grouping of samples,
the algorithm computing the cv.indices will try to equally divide the groups among the subsamples.}

\item{cv.indices}{a list of indices of a cross validation splitting.
If \code{cv.indices = NULL} then a random splitting will be generated using the \code{fold} argument.}

\item{responses}{a vector of responses to simplify and return (if NULL (deafult) no formating will be done)}

\item{max.threads}{Deprecated (will be removed in 2018),
instead use \code{use_parallel = TRUE} and registre parallel backend (see package 'doParallel').
The maximal number of threads to be used.}

\item{use_parallel}{If \code{TRUE} the \code{foreach} loop will use \code{\%dopar\%}.
The user must registre the parallel backend.}

\item{algorithm.config}{the algorithm configuration to be used.}
}
\value{
\item{Y.true}{the response, that is the \code{y} object in data as created by \code{create.sgldata}.}
\item{responses}{content will depend on the C++ response class}
\item{cv.indices}{the cross validation splitting used}
\item{features}{number of features used in the models}
\item{parameters}{number of parameters used in the models}
\item{lambda}{the lambda sequence used.}
}
\description{
Generic sparse group lasso cross validation using multiple possessors
}
\author{
Martin Vincent
}

