\name{plot.variogram}
\title{Plot Variogram}
\usage{plot.variogram(x, ..., var.mod.obj, title.str,ylim, type='c',N=FALSE) }
\alias{plot.variogram}
\arguments{
  \item{x}{a variogram object generated by \code{est.variogram()}}
  \item{var.mod.obj}{a variogram model object generated by a model
    fitting routine.}
  \item{title.str}{optional: an user supplied plot title}
  \item{type}{optional: which type of variogram model to plot,
    \code{'c'} = classical, \code{'r'} = robust, \code{'m'} median}
  \item{N}{logical, toggles printing of absolute pair counts per lag}
  \item{ylim}{optonal user supplied y dimension for the plot}
  \item{...}{additional arguments for \code{plot}}
}
\value{NULL }
\description{Plot empirical variogram estimates, optionally plotting a fitted variogram model. }
\seealso{\code{\link{est.variogram}}}
\examples{
\testonly{
# prepare variables from other example pages if they are not already there:
if(length(ls(pat="maas.vmod"))==0){example(fit.variogram)}
}
# two plots 
oldpar <- par(mfrow=c(2,1))
plot(maas.v) 
plot(maas.v,maas.vmod)
par(oldpar)
}
\references{
http://www.gis.iastate.edu/SGeoStat/homepage.html
}
\keyword{spatial}
