% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hotspot_gistar.R
\name{hotspot_gistar}
\alias{hotspot_gistar}
\title{Identify significant spatial clusters of points}
\usage{
hotspot_gistar(
  data,
  cell_size = NULL,
  grid_type = "rect",
  kde = TRUE,
  bandwidth = NULL,
  nb_dist = NULL,
  include_self = TRUE,
  p_adjust_method = NULL,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{data}{\code{\link[sf]{sf}} data frame containing points.}

\item{cell_size}{\code{numeric} value specifying the size of each equally
spaced grid cell, using the same units (metres, degrees, etc.) as used in
the \code{sf} data frame given in the \code{data} argument. If this
argument is \code{NULL} (the default), the cell size will be calculated
automatically (see Details).}

\item{grid_type}{\code{character} specifying whether the grid should be made
up of squares (\code{"rect"}, the default) or hexagons (\code{"hex"}).}

\item{kde}{\code{TRUE} (the default) or \code{FALSE} indicating whether
kernel density estimates (KDE) should be produced for each grid cell.}

\item{bandwidth}{\code{numeric} value specifying the bandwidth to be used in
calculating the kernel density estimates. If this argument is \code{NULL}
(the default), the bandwidth will be specified automatically using the mean
result of \code{\link[MASS]{bandwidth.nrd}} called on the \code{x} and
\code{y} co-ordinates separately.}

\item{nb_dist}{The distance around a cell that contains the neighbours of
that cell, which are used in calculating the statistic. If this argument is
\code{NULL} (the default), \code{nb_dist} is set as \code{cell_size *
  sqrt(2)} so that only the cells immediately adjacent to each cell are
treated as being its neighbours.}

\item{include_self}{Should points in a given cell be counted as well as
counts in neighbouring cells when calculating the values of
\ifelse{html}{\out{<i>G</i><sub><i>i</i></sub><sup>*</sup>}}{\eqn{G^*_i}}
(if \code{include_self = TRUE}, the default) or
\ifelse{html}{\out{<i>G</i><sub><i>i</i></sub><sup>*</sup>}}{\eqn{G_i}}
(if \code{include_self = FALSE}) values? You are unlikely to want to change
the default value.}

\item{p_adjust_method}{The method to be used to adjust \emph{p}-values for
multiple comparisons. \code{NULL} (the default) uses the default method
used by \code{\link[stats]{p.adjust}}, but any of the character values in
\code{stats::p.adjust.methods} may be specified.}

\item{quiet}{if set to \code{TRUE}, messages reporting the values of any
parameters set automatically will be suppressed. The default is
\code{FALSE}.}

\item{...}{Further arguments passed to \code{\link[SpatialKDE]{kde}} or
ignored if \code{kde = FALSE}.}
}
\value{
An \code{\link[sf]{sf}} tibble of regular grid cells with
corresponding point counts,
\ifelse{html}{\out{<i>G</i><sub><i>i</i></sub><sup>*</sup>}}{\eqn{G_i}} or
\ifelse{html}{\out{<i>G</i><sub><i>i</i></sub><sup>*</sup>}}{\eqn{G^*_i}}
values and (optionally) kernel density estimates for each cell. Values
greater than zero indicate more points than would be expected for randomly
distributed points and values less than zero indicate fewer points.
Critical values of
\ifelse{html}{\out{<i>G</i><sub><i>i</i></sub><sup>*</sup>}}{\eqn{G_i}} and
\ifelse{html}{\out{<i>G</i><sub><i>i</i></sub><sup>*</sup>}}{\eqn{G^*_i}}
are given in the manual page for \code{\link[spdep]{localG}}.

The output from this function can be plotted in the same way as for other
SF objects, for which see \code{vignette("sf5", package = "sf")}.
}
\description{
Identify hotspot and coldspot locations, that is cells in a regular grid in
which there are more/fewer points than would be expected if the points were
distributed randomly.
}
\details{
This function calculates the Getis-Ord
\ifelse{html}{\out{<i>G</i><sub><i>i</i></sub><sup>*</sup>}}{\eqn{G^*_i}}
(gi-star) or
\ifelse{html}{\out{<i>G</i><sub><i>i</i></sub><sup>*</sup>}}{\eqn{G_i}}
\eqn{Z}-score statistic for identifying clusters of point locations. The
underlying implementation uses the \code{\link[spdep]{localG}} function to
calculate the \eqn{Z} scores and then \code{\link[spdep]{p.adjustSP}}
function to adjust the corresponding \eqn{p}-values for multiple comparison.
The function also returns counts of points in each cell and (by default but
optionally) kernel density estimates using the \code{\link[SpatialKDE]{kde}}
function.
\subsection{Coverage of the output data}{

The grid produced by this function covers the convex hull of the input data
layer. This means the result may include
\ifelse{html}{\out{<i>G</i><sub><i>i</i></sub><sup>*</sup>}}{\eqn{G^*_i}} or
\ifelse{html}{\out{<i>G</i><sub><i>i</i></sub><sup>*</sup>}}{\eqn{G_i}}
values for cells that are outside the area for which data were provided,
which could be misleading. To handle this, consider cropping the output layer
to the area for which data are available. For example, if you only have crime
data for a particular district, crop the output dataset to the district
boundary using \code{\link[sf]{st_intersection}}.
}

\subsection{Automatic cell-size selection}{

If no cell size is given then the cell size will be set so that there are 50
cells on the shorter side of the grid. If the \code{data} SF object is projected
in metres or feet, the number of cells will be adjusted upwards so that the
cell size is a multiple of 100.
}
}
\examples{
library(sf)

# Transform data to UTM zone 15N so that cell_size and bandwidth can be set
# in metres
memphis_robberies_utm <- st_transform(memphis_robberies_jan, 32615)

# Automatically set grid-cell size, bandwidth and neighbour distance
\donttest{
hotspot_gistar(memphis_robberies_utm)
}

# Manually set grid-cell size in metres, since the `memphis_robberies`
# dataset uses a co-ordinate reference system (UTM zone 15 north) that is
# specified in metres
\donttest{
hotspot_gistar(memphis_robberies_utm, cell_size = 200)
}

# Automatically set grid-cell size and bandwidth for lon/lat data, since it
# is not intuitive to set these values manually in decimal degrees. To do
# this it is necessary to not calculate KDEs due to a limitation in the
# underlying function.
\donttest{
hotspot_gistar(memphis_robberies, kde = FALSE)
}

}
\references{
Getis, A. & Ord, J. K. (1992). The Analysis of Spatial Association by Use of
Distance Statistics. \emph{Geographical Analysis}, 24(3), 189-206.
doi:\doi{10.1111/j.1538-4632.1992.tb00261.x}
}
