% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.R
\name{sf_multipolygon}
\alias{sf_multipolygon}
\title{sf MULTIPOLYGON}
\usage{
sf_multipolygon(
  obj = NULL,
  x = NULL,
  y = NULL,
  z = NULL,
  m = NULL,
  multipolygon_id = NULL,
  polygon_id = NULL,
  linestring_id = NULL,
  close = TRUE,
  keep = FALSE
)
}
\arguments{
\item{obj}{sorted matrix or data.frame}

\item{x}{x geometry column}

\item{y}{y geometry column}

\item{z}{z geometry column}

\item{m}{m geometry column}

\item{multipolygon_id}{column of ids for multipolygons}

\item{polygon_id}{column of ids for polygons}

\item{linestring_id}{column of ids for lines (within polygons)}

\item{close}{logical indicating whether polygons should be closed. If \code{TRUE},
all polygons will be checked and force closed if possible}

\item{keep}{logical indicating if the non-geometry and non-id columns should be kept.
if TRUE you must supply the geometry and id columns, and only the first row of
each geometry is kept. See Keeping Properties.}
}
\value{
\code{sf} object of MULTIPOLYGON geometries
}
\description{
constructs an sf of MULTIPOLYGON objects
}
\section{notes}{

sfheaders functions do not perform any validity checks on the geometries.
Nor do they set Coordinate Reference Systems, EPSG, PROJ4 or precision attributes.

The data.frame and matrices you send into the sfheader functions must be ordered.
}

\section{Keeping Properties}{


Setting \code{keep = TRUE} will retain the first row of any columns not specified as a
coordinate (x, y, z, m) or an id (e.g., linestring_id, polygon_id) of the input \code{obj}.

The \code{sf_*} functions assume the input \code{obj} is a long data.frame / matrix,
where any properties are repeated down the table for the same geometry.
}

\examples{

m <- matrix(c(0,0,0,0,1,0,0,1,1,0,0,1,0,0,0), ncol = 3, byrow = TRUE )
sf_multipolygon( m )

df <- data.frame(
  id = c(1,1,1,1,1)
  , x = c(0,0,1,1,0)
  , y = c(0,1,1,0,0)
)

sf_multipolygon( df, x = "x", y = "y" )

df <- data.frame(
  id = c(1,1,1,1,1,2,2,2,2,2)
  , x = c(0,0,1,1,0,1,1,2,2,1)
  , y = c(0,1,1,0,0,1,2,2,1,1)
)

sf_multipolygon( df, multipolygon_id = "id", polygon_id = "id", linestring_id = "id")

df <- data.frame(
  id1 = c(1,1,1,1,1,1,1,1,1,1)
  , id2 = c(1,1,1,1,1,2,2,2,2,2)
  , x = c(0,0,1,1,0,1,1,2,2,1)
  , y = c(0,1,1,0,0,1,2,2,1,1)
)

sf_multipolygon( df, multipolygon_id = "id1", polygon_id = "id2")

df <- data.frame(
  id1 = c(1,1,1,1,1,1,1,1,1,1,2,2,2,2,2)
  , id2 = c(1,1,1,1,1,2,2,2,2,2,1,1,1,1,1)
  , x = c(0,0,1,1,0,1,1,2,2,1,3,3,4,4,3)
  , y = c(0,1,1,0,0,1,2,2,1,1,3,4,4,3,3)
)

sf_multipolygon( df, multipolygon_id = "id1", polygon_id = "id2")

df <- data.frame(
  id1 = c(1,1,1,1,1,2,2,2,2,2)
  , id2 = c(1,1,1,1,1,1,1,1,1,1)
  , x = c(0,0,1,1,0,1,1,2,2,1)
  , y = c(0,1,1,0,0,1,2,2,1,1)
)

sf_multipolygon( df, multipolygon_id = "id1", polygon_id = "id2" )
sf_multipolygon( df, polygon_id = "id1", linestring_id = "id2" )
sf_multipolygon( df, x = "x", y = "y", polygon_id = "id1")
sf_multipolygon( df, x = "x", y = "y", polygon_id = "id1", linestring_id = "id2")
sf_multipolygon( df, x = "x", y = "y", linestring_id = "id1")
sf_multipolygon( df, x = "x", y = "y", linestring_id = "id2")

df <- data.frame(
  id1 = c('a','a','a','a','a','b','b','b','b','b')
  , id2 = c(1,1,1,1,1,1,1,1,1,1)
  , x = c(0,0,1,1,0,1,1,2,2,1)
  , y = c(0,1,1,0,0,1,2,2,1,1)
)

sf_multipolygon( df, x = "x", y = "y", polygon_id = "id1")

}
