% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisa.R
\name{local_moran}
\alias{local_moran}
\title{Calculate the Local Moran's I Statistic}
\usage{
local_moran(x, nb, wt, alternative = "two.sided", nsim = 499, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{nb}{a neighbor list object for example as created by \code{st_contiguity()}.}

\item{wt}{a weights list as created by \code{st_weights()}.}

\item{alternative}{default \code{"two.sided"}. Should be one of \code{"greater"}, \code{"less"}, or \code{"two.sided"} to specify the alternative hypothesis.}

\item{nsim}{The number of simulations to run.}

\item{...}{See \code{?spdep::localmoran_perm()} for more options.}
}
\value{
a \code{data.frame} containing the columns \code{ii}, \code{eii}, \code{var_ii}, \code{z_ii}, \code{p_ii}, \code{p_ii_sim}, and \code{p_folded_sim}. For more details please see \code{\link[spdep:localmoran]{spdep::localmoran_perm()}}.
}
\description{
Moran's I is calculated for each polygon based on the neighbor and weight lists.
}
\details{
\code{\link[=local_moran]{local_moran()}} calls \code{\link[spdep:localmoran]{spdep::localmoran_perm()}} and calculates the Moran I for each polygon. As well as provide simulated p-values.
}
\examples{
library(magrittr)
lisa <- guerry \%>\%
  dplyr::mutate(nb = st_contiguity(geometry),
         wt = st_weights(nb),
         moran = local_moran(crime_pers, nb, wt))

# unnest the dataframe column
tidyr::unnest(lisa, moran)
}
\seealso{
Other stats: 
\code{\link{st_lag}()}
}
\concept{stats}
