% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R, R/join.R
\name{dplyr}
\alias{dplyr}
\alias{filter.sf}
\alias{dplyr}
\alias{arrange.sf}
\alias{dplyr}
\alias{distinct.sf}
\alias{dplyr}
\alias{group_by.sf}
\alias{dplyr}
\alias{ungroup.sf}
\alias{dplyr}
\alias{mutate.sf}
\alias{dplyr}
\alias{transmute.sf}
\alias{dplyr}
\alias{select.sf}
\alias{dplyr}
\alias{rename.sf}
\alias{dplyr}
\alias{slice.sf}
\alias{dplyr}
\alias{summarise.sf}
\alias{summarise}
\alias{dplyr}
\alias{gather.sf}
\alias{dplyr}
\alias{spread.sf}
\alias{dplyr}
\alias{sample_n.sf}
\alias{dplyr}
\alias{sample_frac.sf}
\alias{dplyr}
\alias{nest.sf}
\alias{dplyr}
\alias{separate.sf}
\alias{dplyr}
\alias{unite.sf}
\alias{dplyr}
\alias{unnest.sf}
\alias{dplyr}
\alias{inner_join.sf}
\alias{dplyr}
\alias{left_join.sf}
\alias{dplyr}
\alias{right_join.sf}
\alias{dplyr}
\alias{full_join.sf}
\alias{dplyr}
\alias{semi_join.sf}
\alias{dplyr}
\alias{anti_join.sf}
\title{Dplyr verb methods for sf objects}
\usage{
filter.sf(.data, ..., .dots)

arrange.sf(.data, ..., .dots)

distinct.sf(.data, ..., .dots, .keep_all = FALSE)

group_by.sf(.data, ..., .dots, add = FALSE)

ungroup.sf(x, ...)

mutate.sf(.data, ..., .dots)

transmute.sf(.data, ..., .dots)

select.sf(.data, ...)

rename.sf(.data, ...)

slice.sf(.data, ..., .dots)

summarise.sf(.data, ..., .dots, do_union = TRUE)

gather.sf(data, key, value, ..., na.rm = FALSE, convert = FALSE,
  factor_key = FALSE)

spread.sf(data, key, value, fill = NA, convert = FALSE, drop = TRUE,
  sep = NULL)

sample_n.sf(tbl, size, replace = FALSE, weight = NULL,
  .env = parent.frame())

sample_frac.sf(tbl, size = 1, replace = FALSE, weight = NULL,
  .env = parent.frame())

nest.sf(data, ..., .key = "data")

separate.sf(data, col, into, sep = "[^[:alnum:]]+", remove = TRUE,
  convert = FALSE, extra = "warn", fill = "warn", ...)

unite.sf(data, col, ..., sep = "_", remove = TRUE)

unnest.sf(data, ..., .preserve = NULL)

inner_join.sf(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

left_join.sf(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

right_join.sf(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

full_join.sf(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

semi_join.sf(x, y, by = NULL, copy = FALSE, ...)

anti_join.sf(x, y, by = NULL, copy = FALSE, ...)
}
\arguments{
\item{.data}{data object of class \link{sf}}

\item{...}{other arguments}

\item{.dots}{see corresponding function in package \code{dplyr}}

\item{.keep_all}{see corresponding function in dplyr}

\item{add}{see corresponding function in dplyr}

\item{x}{see \link[dplyr]{left_join}}

\item{do_union}{logical; should geometries be unioned by using \link{st_union}, or simply be combined using \link{st_combine}? Using \link{st_union} resolves internal boundaries, but in case of unioning points may also change the order of the points.}

\item{data}{see original function docs}

\item{key}{see original function docs}

\item{value}{see original function docs}

\item{na.rm}{see original function docs}

\item{convert}{see original function docs}

\item{factor_key}{see original function docs}

\item{fill}{see original function docs}

\item{drop}{see original function docs}

\item{sep}{see original function docs}

\item{tbl}{see original function docs}

\item{size}{see original function docs}

\item{replace}{see original function docs}

\item{weight}{see original function docs}

\item{.env}{see original function docs}

\item{.key}{see \link[tidyr]{nest}}

\item{col}{see \link[tidyr]{separate}}

\item{into}{see \link[tidyr]{separate}}

\item{remove}{see \link[tidyr]{separate}}

\item{extra}{see \link[tidyr]{separate}}

\item{.preserve}{see \link[tidyr]{unnest}}

\item{y}{see \link[dplyr]{left_join}}

\item{by}{see \link[dplyr]{left_join}}

\item{copy}{see \link[dplyr]{left_join}}

\item{suffix}{see \link[dplyr]{left_join}}
}
\description{
Dplyr verb methods for sf objects. Geometries are sticky, use \link{as.data.frame} to let \code{dplyr}'s own methods drop them.
}
\details{
\code{select} keeps the geometry regardless whether it is selected or not; to deselect it, first pipe through \code{as.data.frame} to let dplyr's own \code{select} drop it.

\code{nest.sf} assumes that a simple feature geometry list-column was among the columns that were nested.
}
\examples{
library(dplyr)
nc = st_read(system.file("shape/nc.shp", package="sf"))
nc \%>\% filter(AREA > .1) \%>\% plot()
# plot 10 smallest counties in grey:
st_geometry(nc) \%>\% plot()
nc \%>\% select(AREA) \%>\% arrange(AREA) \%>\% slice(1:10) \%>\% plot(add = TRUE, col = 'grey')
title("the ten counties with smallest area")
nc[c(1:100, 1:10), ] \%>\% distinct() \%>\% nrow()
nc$area_cl = cut(nc$AREA, c(0, .1, .12, .15, .25))
nc \%>\% group_by(area_cl) \%>\% class()
nc2 <- nc \%>\% mutate(area10 = AREA/10)
nc \%>\% transmute(AREA = AREA/10, geometry = geometry) \%>\% class()
nc \%>\% transmute(AREA = AREA/10) \%>\% class()
nc \%>\% select(SID74, SID79) \%>\% names()
nc \%>\% select(SID74, SID79, geometry) \%>\% names()
nc \%>\% select(SID74, SID79) \%>\% class()
nc \%>\% select(SID74, SID79, geometry) \%>\% class()
nc2 <- nc \%>\% rename(area = AREA)
nc \%>\% slice(1:2)
nc$area_cl = cut(nc$AREA, c(0, .1, .12, .15, .25))
nc.g <- nc \%>\% group_by(area_cl)
nc.g \%>\% summarise(mean(AREA))
nc.g \%>\% summarise(mean(AREA)) \%>\% plot(col = grey(3:6 / 7))
nc \%>\% as.data.frame \%>\% summarise(mean(AREA))
library(tidyr)
nc \%>\% select(SID74, SID79, geometry) \%>\% gather(VAR, SID, -geometry) \%>\% summary()
library(tidyr)
nc$row = 1:100 # needed for spread to work
nc \%>\% select(SID74, SID79, geometry, row) \%>\%
	gather(VAR, SID, -geometry, -row) \%>\%
	spread(VAR, SID) \%>\% head()
storms.sf = st_as_sf(storms, coords = c("long", "lat"), crs = 4326)
x <- storms.sf \%>\% group_by(name, year) \%>\% nest
trs = lapply(x$data, function(tr) st_cast(st_combine(tr), "LINESTRING")[[1]]) \%>\% st_sfc(crs = 4326)
trs.sf = st_sf(x[,1:2], trs)
plot(trs.sf["year"], axes = TRUE)
}
