% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{st_split}
\alias{st_split}
\title{Return a collection of geometries resulting by splitting a geometry}
\usage{
st_split(x, y)
}
\arguments{
\item{x}{object with geometries to be splitted}

\item{y}{object split with (blade); if \code{y} contains more than one feature geometry, the geometries are \link{st_combine}d}
}
\value{
object of the same class as \code{x}
}
\description{
Return a collection of geometries resulting by splitting a geometry
}
\details{
\code{st_split} is only available if the package was linked against liblwgeom, which is currently not the case for the binary CRAN distributions; see the package source code repository for instructions how to install liblwgeom. The example below shows how to run-time check the availability of liblwgeom.
}
\examples{
l = st_as_sfc('MULTILINESTRING((10 10, 190 190), (15 15, 30 30, 100 90))')
pt = st_sfc(st_point(c(30,30)))
if (!is.na(sf_extSoftVersion()["lwgeom"])) {
  st_split(l, pt)
}
}
