library(RPostgreSQL)
suppressPackageStartupMessages(library(sf))
library(sp)
if (Sys.getenv("USER") %in% c("travis", "edzer")) {
  data(meuse)
  sf = st_as_sf(meuse, coords = c("x", "y"), crs = 28992)
  conn = dbConnect(PostgreSQL(), dbname = "postgis")
  st_write_db(conn, sf, "meuse_tbl", try_drop = TRUE)
  # try with schema:
  st_write_db(conn, sf, c("public", "meuse_tbl"), try_drop = TRUE)
  st_write_db(conn, sf, "meuse_tbl2", binary = FALSE)
  x = st_read_db(conn, query = "select * from meuse_tbl limit 30;")
  y = st_read_db(conn, "meuse_tbl2") 
  dbDisconnect(conn)
}

options(warn = 2) # turn into error
if (Sys.getenv("USER") %in% c("edzer", "travis")) {
#if (Sys.getenv("USER") %in% c("edzer")) {
  cn = dbConnect(PostgreSQL(), dbname = "postgis")
  round_trip = function(cn, wkt) {
  	query = paste0("SELECT '", wkt, "'::geometry;")
	returnstr = suppressWarnings(dbGetQuery(cn, query)$geometry)
  	wkb = structure(returnstr, class = "WKB")
    ret = st_as_sfc(wkb, EWKB = TRUE)
    cat(paste("IN:  ", wkt, "\n"))
	# OUT contains WKB created in PostGIS from wkt, interpreted to R by sf, printed as WKT by sf
	cat(paste("OUT: ", txt <- st_as_text(ret, EWKT=TRUE)[[1]], "\n"))
	if (length(grep("SRID", txt)) == 0) {
	  query = paste0("SELECT ST_AsText('",sf:::CPL_raw_to_hex(st_as_binary(ret[[1]])),"');")
	  str = suppressWarnings(dbGetQuery(cn, query)$st_astext)
	  # PG: contains the PostGIS WKT, after reading the WKB created by sf from R native
	  cat(paste("PG:  ", str, "\n"))
	}
	invisible(ret)
  }
  round_trip(cn, "SRID=4326;POINTM(0 0 0)")
  round_trip(cn, "POINTZ(0 0 0)")
  round_trip(cn, "POINTZM(0 0 0 0)")
  round_trip(cn, "POINT(0 0)")
  round_trip(cn, "LINESTRING(0 0,1 1,2 2)")
  round_trip(cn, "MULTIPOINT(0 0,1 1,2 2)")
  round_trip(cn, "POLYGON((0 0,1 0,1 1,0 0))")
  round_trip(cn, "MULTIPOLYGON(((0 0,1 0,1 1,0 0)),((2 2,3 2,3 3,2 2)))")
  round_trip(cn, "MULTIPOLYGON(((0 0,1 0,1 1,0 0),(.2 .2,.8 .2, .8 .8, .2 .2)),((2 2,3 2,3 3,2 2)))")
  round_trip(cn, "MULTILINESTRING((0 0,1 0,1 1,0 0),(.2 .2,.8 .2, .8 .8, .2 .2),(2 2,3 2,3 3,2 2))")

# other types; examples taken from the PostGIS manuals (ch 4):

  round_trip(cn, "CIRCULARSTRING(0 0, 1 1, 1 0)")
  round_trip(cn, "CIRCULARSTRING(0 0, 4 0, 4 4, 0 4, 0 0)")
  round_trip(cn, "CURVEPOLYGON(CIRCULARSTRING(0 0, 4 0, 4 4, 0 4, 0 0),(1 1, 3 3, 3 1, 1 1))")
  round_trip(cn, "COMPOUNDCURVE(CIRCULARSTRING(0 0, 1 1, 1 0),(1 0, 0 1))")
  round_trip(cn, "CURVEPOLYGON(COMPOUNDCURVE(CIRCULARSTRING(0 0,2 0, 2 1, 2 3, 4 3),(4 3, 4 5, 1 4, 0 0)), CIRCULARSTRING(1.7 1, 1.4 0.4, 1.6 0.4, 1.6 0.5, 1.7 1))")
  round_trip(cn, "MULTICURVE((0 0, 5 5),CIRCULARSTRING(4 0, 4 4, 8 4))")
  round_trip(cn, "MULTISURFACE(CURVEPOLYGON(CIRCULARSTRING(0 0, 4 0, 4 4, 0 4, 0 0),(1 1, 3 3, 3 1, 1 1)),((10 10, 14 12, 11 10, 10 10),(11 11, 11.5 11, 11 11.5, 11 11)))")

  round_trip(cn, "MULTICURVE( (0 0, 5 5), CIRCULARSTRING(4 0, 4 4, 8 4) )")
  round_trip(cn, "POLYHEDRALSURFACE( ((0 0 0, 0 0 1, 0 1 1, 0 1 0, 0 0 0)), ((0 0 0, 0 1 0, 1 1 0, 1 0 0, 0 0 0)), ((0 0 0, 1 0 0, 1 0 1, 0 0 1, 0 0 0)), ((1 1 0, 1 1 1, 1 0 1, 1 0 0, 1 1 0)), ((0 1 0, 0 1 1, 1 1 1, 1 1 0, 0 1 0)), ((0 0 1, 1 0 1, 1 1 1, 0 1 1, 0 0 1)) )")
  round_trip(cn, "TRIANGLE ((0 0, 0 9, 9 0, 0 0))")
  round_trip(cn, "TIN( ((0 0 0, 0 0 1, 0 1 0, 0 0 0)), ((0 0 0, 0 1 0, 1 1 0, 0 0 0)) )")


  #options(warn = -1)
  #query = paste0("SELECT wkb_geometry from meuse limit 2;")
  #wkb = as.list(dbGetQuery(cn, query)$wkb_geometry)
  #class(wkb) = "WKB"
  #ret = st_as_sfc(wkb, EWKB = TRUE)
  #ret 

  #m = st_read_db(cn, query = "select * from meuse;")
  dbDisconnect(cn)
}

if (Sys.getenv("USER") %in% c("travis", "edzer")) {
  suppressWarnings(x <- st_read("PG:dbname=postgis"))
  try(x <- st_read("PG:dbname=empty")) # error
  print(st_layers("PG:dbname=postgis"))
  print(st_layers("PG:dbname=empty"))
}
