% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-http.R
\name{api}
\alias{api}
\title{Core HTTP logic for Seven Bridges API}
\usage{
api(
  token = NULL,
  path = NULL,
  method = c("GET", "POST", "PUT", "DELETE", "PATCH"),
  query = NULL,
  body = list(),
  encode = c("json", "form", "multipart"),
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  advance_access = getOption("sevenbridges2")$advance_access,
  authorization = FALSE,
  fields = "_all",
  base_url = NULL,
  url = NULL,
  ...
)
}
\arguments{
\item{token}{API authentication token or \code{access_token} for Seven Bridges
single sign-on. Authentication token uniquely identifies you on the Seven
Bridges Platform and has all your data access, app management and task
execution permissions. Read more about its usage
\href{https://docs.sevenbridges.com/docs/get-your-authentication-token}{here}.}

\item{path}{Path connected with \code{base_url}.}

\item{method}{One of \code{"GET"}, \code{"POST"}, \code{"PUT"}, \code{"DELETE"}, or \code{"PATCH"}.}

\item{query}{Query parameters passed to httr package GET/POST call.}

\item{body}{Body content passed to httr package GET/POST/PUT/DELETE/PATCH
call.}

\item{encode}{If the body is a named list, how should it be
encoded? Can be one of \code{"json"} (application/json),
\code{"form"} (application/x-www-form-urlencoded),
or \code{"multipart"} (multipart/form-data).
Default is \code{"json"}.
For \code{"multipart"}, list elements can be strings
or objects created by \code{\link[httr:upload_file]{httr::upload_file()}}.
For "form", elements are coerced to strings and escaped,
use \code{I()} to prevent double-escaping.
For \code{"json"}, parameters are automatically "unboxed"
(i.e. length 1 vectors are converted to scalars). To preserve
a length 1 vector as a vector, wrap in \code{I()}.}

\item{limit}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{offset}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{advance_access}{Enable advance access features?
Default is \code{FALSE}.}

\item{authorization}{Is the \code{token} an API
authentication token (\code{FALSE}) or an access token from the
Seven Bridges single sign-on (\code{TRUE})?}

\item{fields}{Selector specifying a subset of fields to include in the
response. All API calls take this optional query parameter.
This parameter enables you to specify the fields you want to be returned
when listing resources (e.g. all your projects) or getting details of a
specific resource (e.g. a given project). \cr \cr
For example, \code{fields="id,name,size"} to return the fields
id, name and size for files. Default value is set to
\verb{_all}, so all fields are always returned for each resource.
More details please check
\href{https://docs.sevenbridges.com/docs/the-api#section-general-api-information}{here}.}

\item{base_url}{Platform URL, default is NULL.}

\item{url}{Full url of the resource. If \code{url} is provided,
other parameters like \code{base_url}, \code{path}, \code{query}, \code{limit},
\code{offset} and \code{fields} will be ignored.}

\item{...}{Other arguments passed to GET/POST/PUT/DELETE/PATCH call.}
}
\value{
Response in form of a list.
}
\description{
Used for advanced users and the core method for higher level API
in this package.
}
\examples{
token <- "your_token"
# list projects
\dontrun{
api(token = token, path = "projects", method = "GET")
}

}
\references{
\url{https://docs.sevenbridges.com/page/api}
}
