% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-invoice.R
\name{Invoice}
\alias{Invoice}
\title{R6 Class representing invoice information.}
\description{
R6 Class representing invoice information.
}
\details{
This object contains information about a selected invoice,
including the costs for analysis and storage, and the invoice period.
}
\examples{

## ------------------------------------------------
## Method `Invoice$print`
## ------------------------------------------------

\dontrun{
 # x is API response when invoice is requested
 invoice_object <- Invoice$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print invoice object
 invoice_object$print()
}


## ------------------------------------------------
## Method `Invoice$reload`
## ------------------------------------------------

\dontrun{
 # x is API response when invoice is requested
 invoice_object <- Invoice$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Reload invoice object
 invoice_object$reload()
}

}
\section{Super class}{
\code{\link[sevenbridges2:Item]{sevenbridges2::Item}} -> \code{Invoice}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}

\item{\code{id}}{Invoice identifier.}

\item{\code{pending}}{Invoice approval status.}

\item{\code{approval_date}}{Invoice approval date.}

\item{\code{invoice_period}}{Invoicing period (from-to).}

\item{\code{analysis_costs}}{Costs of your analysis.}

\item{\code{storage_costs}}{Storage costs.}

\item{\code{total}}{Total costs.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Invoice-new}{\code{Invoice$new()}}
\item \href{#method-Invoice-print}{\code{Invoice$print()}}
\item \href{#method-Invoice-reload}{\code{Invoice$reload()}}
\item \href{#method-Invoice-clone}{\code{Invoice$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Invoice-new"></a>}}
\if{latex}{\out{\hypertarget{method-Invoice-new}{}}}
\subsection{Method \code{new()}}{
Create new Invoice object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Invoice$new(res = NA, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{res}}{Response containing Invoice object information.}

\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Invoice-print"></a>}}
\if{latex}{\out{\hypertarget{method-Invoice-print}{}}}
\subsection{Method \code{print()}}{
Print invoice information as a bullet list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Invoice$print()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when invoice is requested
 invoice_object <- Invoice$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print invoice object
 invoice_object$print()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Invoice-reload"></a>}}
\if{latex}{\out{\hypertarget{method-Invoice-reload}{}}}
\subsection{Method \code{reload()}}{
Reload Invoice.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Invoice$reload(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Invoice}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when invoice is requested
 invoice_object <- Invoice$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Reload invoice object
 invoice_object$reload()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Invoice-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Invoice-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Invoice$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
