% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asSet.R
\name{as.Set}
\alias{as.Set}
\alias{as.Set.default}
\alias{as.Set.numeric}
\alias{as.Set.list}
\alias{as.Set.matrix}
\alias{as.Set.data.frame}
\alias{as.Set.Set}
\alias{as.Set.FuzzySet}
\alias{as.Set.Interval}
\alias{as.Set.ConditionalSet}
\alias{as.Tuple}
\alias{as.Tuple.default}
\alias{as.Tuple.numeric}
\alias{as.Tuple.list}
\alias{as.Tuple.matrix}
\alias{as.Tuple.data.frame}
\alias{as.Tuple.FuzzySet}
\alias{as.Tuple.Set}
\alias{as.Tuple.Interval}
\alias{as.Tuple.ConditionalSet}
\title{Coercion to R6 \code{Set}/\code{Tuple}}
\usage{
as.Set(object)

\method{as.Set}{default}(object)

\method{as.Set}{numeric}(object)

\method{as.Set}{list}(object)

\method{as.Set}{matrix}(object)

\method{as.Set}{data.frame}(object)

\method{as.Set}{Set}(object)

\method{as.Set}{FuzzySet}(object)

\method{as.Set}{Interval}(object)

\method{as.Set}{ConditionalSet}(object)

as.Tuple(object)

\method{as.Tuple}{default}(object)

\method{as.Tuple}{numeric}(object)

\method{as.Tuple}{list}(object)

\method{as.Tuple}{matrix}(object)

\method{as.Tuple}{data.frame}(object)

\method{as.Tuple}{FuzzySet}(object)

\method{as.Tuple}{Set}(object)

\method{as.Tuple}{Interval}(object)

\method{as.Tuple}{ConditionalSet}(object)
}
\arguments{
\item{object}{object to coerce}
}
\description{
Coerces object to an R6 \link{Set}/\link{Tuple}
}
\details{
\itemize{
\item \code{as.Set.default} - Creates a \link{Set} using the object as the elements.
\item \code{as.Set.list} - Creates a \link{Set} for each element in \code{list}.
\item \code{as.Set.matrix/as.Set.data.frame} - Creates a \link{Set} for each column in \code{matrix/data.frame}.
\item \code{as.Set.FuzzySet} - Creates a \link{Set} from the support of the \link{FuzzySet}.
\item \code{as.Set.Interval} - If the interval has finite cardinality then creates a \link{Set} from the \link{Interval} elements.
}
}
\seealso{
\link{Set} \link{Tuple}

Other coercions: 
\code{\link{as.FuzzySet}()},
\code{\link{as.Interval}()}
}
\concept{coercions}
