% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetWrapper.R
\name{SetWrapper}
\alias{SetWrapper}
\title{Abstract SetWrapper Class}
\description{
This class should not be constructed directly. Parent class to \code{SetWrapper}s.
}
\section{Super class}{
\code{\link[set6:Set]{set6::Set}} -> \code{SetWrapper}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{wrappedSets}}{Returns the list of \code{Set}s that are wrapped in the given wrapper.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SetWrapper$new()}}
\item \href{#method-equals}{\code{SetWrapper$equals()}}
\item \href{#method-isSubset}{\code{SetWrapper$isSubset()}}
\item \href{#method-clone}{\code{SetWrapper$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="add">}\href{../../set6/html/Set.html#method-add}{\code{set6::Set$add()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="contains">}\href{../../set6/html/Set.html#method-contains}{\code{set6::Set$contains()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="print">}\href{../../set6/html/Set.html#method-print}{\code{set6::Set$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="remove">}\href{../../set6/html/Set.html#method-remove}{\code{set6::Set$remove()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="strprint">}\href{../../set6/html/Set.html#method-strprint}{\code{set6::Set$strprint()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="summary">}\href{../../set6/html/Set.html#method-summary}{\code{set6::Set$summary()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{SetWrapper} object. It is not recommended to construct this class directly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SetWrapper$new(
  setlist,
  lower = NULL,
  upper = NULL,
  type = NULL,
  class = NULL,
  cardinality
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{setlist}}{List of \link{Set}s to wrap.}

\item{\code{lower}}{\link{Set}. Lower bound of wrapper.}

\item{\code{upper}}{\link{Set}. Upper bound of wrapper.}

\item{\code{type}}{character. Closure type of wrapper.}

\item{\code{class}}{character. Ignored.}

\item{\code{cardinality}}{character or integer. Cardinality of wrapper.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{SetWrapper} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-equals"></a>}}
\subsection{Method \code{equals()}}{
Tests if \code{x} is equal to \code{self}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SetWrapper$equals(x, all = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\link{Set} or vector of \link{Set}s.}

\item{\code{x}}{any. Object or vector of objects to test.}

\item{\code{all}}{logical. If \code{FALSE} tests each \code{x} separately. Otherwise returns \code{TRUE} only if all \code{x} pass test.}

\item{\code{all}}{logical. If \code{FALSE} tests each \code{x} separately. Otherwise returns \code{TRUE} only if all \code{x} pass test.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{all == TRUE} then returns \code{TRUE} if all \code{x} are equal to \code{self}, otherwise \code{FALSE}.
If \code{all == FALSE} returns a vector of logicals corresponding to the length of \code{x}, representing
if each is equal to \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isSubset"></a>}}
\subsection{Method \code{isSubset()}}{
Tests if \code{x} is a (proper) subset of \code{self}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SetWrapper$isSubset(x, proper = FALSE, all = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\link{Set} or vector of \link{Set}s.}

\item{\code{x}}{any. Object or vector of objects to test.}

\item{\code{proper}}{logical. If \code{TRUE} tests for proper subsets.}

\item{\code{all}}{logical. If \code{FALSE} tests each \code{x} separately. Otherwise returns \code{TRUE} only if all \code{x} pass test.}

\item{\code{all}}{logical. If \code{FALSE} tests each \code{x} separately. Otherwise returns \code{TRUE} only if all \code{x} pass test.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{all == TRUE} then returns \code{TRUE} if all \code{x} are (proper) subsets of \code{self}, otherwise \code{FALSE}.
If \code{all == FALSE} returns a vector of logicals corresponding to the length of \code{x}, representing
if each is a (proper) subset of \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SetWrapper$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
