% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Set_FuzzySet.R
\name{inclusion}
\alias{inclusion}
\title{Get Inclusion Level of Element In FuzzySet}
\arguments{
\item{element}{element or list of elements in fuzzy set for which to get the inclusion level}
}
\value{
One of: "Included", "Partially Included", "Not Included"
}
\description{
An element in a fuzzy set, with corresponding membership \eqn{m}, is:
\itemize{
\item Included - If \eqn{m = 1}
\item Partially Included - If \eqn{0 < m < 1}
\item Not Included - If \eqn{m = 0}
}
}
\details{
For \link{FuzzySet}s this is straightforward and returns the inclusion level of the given element(s),
however in \link{FuzzyTuple}s when an element may be duplicated, the function returns the inclusion level of
all instances of the element.
}
\section{R6 Usage}{
 $inclusion(element)
}

\examples{
f = FuzzySet$new(0.1, 0, 1, 0.1, 2, 0.5, 3, 1)
f$inclusion(0.1)
f$inclusion(1)
f$inclusion(3)
}
