% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/static.R
\name{httd}
\alias{httd}
\alias{httw}
\title{Serve static files under a directory}
\usage{
httd(dir = ".", ...)

httw(
  dir = ".",
  watch = ".",
  pattern = NULL,
  all_files = FALSE,
  filter = NULL,
  handler = NULL,
  ...
)
}
\arguments{
\item{dir}{The root directory to serve.}

\item{...}{server configurations passed to \code{\link{server_config}()}}

\item{watch}{a directory under which \code{httw()} is to watch for changes;
if it is a relative path, it is relative to the \code{dir} argument}

\item{pattern}{a regular expression passed to \code{\link{list.files}()} to
determine the files to watch}

\item{all_files}{whether to watch all files including the hidden files}

\item{filter}{a function to filter the file paths returned from
\code{list.files()} (e.g., you can exclude certain files from the watch
list)}

\item{handler}{a function to be called every time any files are changed or
added under the directory; its argument is a character vector of the
filenames of the files modified or added}
}
\description{
If there is an \file{index.html} under this directory, it will be displayed;
otherwise the list of files is displayed, with links on their names. After we
run this function, we can go to \samp{http://localhost:port} to browse the
web pages either created from R or read from HTML files.
}
\details{
\code{httd()} is a pure static server, and \code{httw()} is similar but
watches for changes under the directory: if an HTML file is being viewed in
the browser, and any files are modified under the directory, the HTML page
will be automatically refreshed.
}
\examples{
#' see https://github.com/yihui/servr for command line usage
# or run inside an R session
if (interactive()) servr::httd()
}
\references{
\url{https://github.com/yihui/servr}
}
