% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_clean_functions.R
\name{getFiles}
\alias{getFiles}
\title{Return a list of data frames generated from the servosphere}
\usage{
getFiles(path, pattern, full.names = TRUE)
}
\arguments{
\item{path}{A string for the file path.}

\item{pattern}{A string with a unique pattern to look for in file names.}

\item{full.names}{Return the full file path when TRUE or the file name when
FALSE.}
}
\value{
A list where each item is a data.table
}
\description{
Import all the .csv files in a single directory and convert
them to a list of data frames
}
\details{
When using the servosphere, each trial produces a .csv file that contains the
data from that trial. This data should include a column for time (dT),
position (dX, dY), and the stimulus. All the data files the user wishes to
analyze should be in the same directory. They should also have a common
naming convention to facilitate the identification of these files (i.e.
"x_servosphere.csv", where x might be the date the trial was run or the
unique trial ID).

Other functions in this package require that all the .csv files from the
servosphere that the user wishes to analyze are contained in a list, where
each item in the list is a data.table created from each .csv file.

This function makes use of the data.table package to read in the .csv files,
as it is currently the fastest way to bring in such files. This function is
noticeably slower when alternative csv reading functions are used and when
the number of .csv files is large.
}
\examples{
servosphere <- getFiles("./extdata/", pattern = "_servosphere.csv")
}
