% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mhUpdateVoigt}
\alias{mhUpdateVoigt}
\title{Update the parameters of the Voigt peaks using marginal Metropolis-Hastings.}
\usage{
mhUpdateVoigt(spectra, n, kappa, conc, wavenum, thetaMx, logThetaMx,
  mhChol, priors)
}
\arguments{
\item{spectra}{\code{n_y * nwl} Matrix of observed Raman spectra.}

\item{n}{number of observations to use in calculating the likelihood.}

\item{kappa}{likelihood tempering parameter.}

\item{conc}{Vector of \code{n_y} nanomolar (nM) dye concentrations}

\item{wavenum}{Vector of \code{nwl} wavenumbers at which the spetra are observed.}

\item{thetaMx}{\code{(4+npeaks*4) x npart} Matrix of parameter values for each peak.}

\item{logThetaMx}{\code{(4+npeaks*4) x npart} Matrix of logarithms of the parameters.}

\item{mhChol}{lower-triangular Cholesky factorisation of the covariance matrix for the random walk proposals.}

\item{priors}{List of hyperparameters for the prior distributions.}
}
\value{
The number of RWMH proposals that were accepted.
}
\description{
Updates all of the parameters (location, amplitude, std. dev., and scale) using a single Metropolis-
Hastings step, such that the baseline cancels out in the MH ratio, using the marginalisation identity
of Chib (1995).
Note: if \code{npart > 1}, then multiple MCMC chains will be executed independently in parallel using
OpenMP. This means that all functions used for the proposal distributions and to evaluate the MH ratio
need to be thread-safe. Specifically, no calls to \code{R::rnorm}, \code{R::dnorm}, nor their
Rcpp equivalents, can be made from within the parallel portion of the code.
}
\references{
Chib (1995) "Marginal Likelihood from the Gibbs Output," JASA 90(432): 1313--1321,
DOI: \href{http://dx.doi.org/10.1080/01621459.1995.10476635}{10.1080/01621459.1995.10476635}

Rosenthal (2000) "Parallel computing and Monte Carlo algorithms" Far East J. Theor. Stat. 4(2): 207--236,
URL: \href{http://www.pphmj.com/abstract/1961.htm}{http://www.pphmj.com/abstract/1961.htm}
}
