% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backlinks.R
\name{sst_bl_domain_summary}
\alias{sst_bl_domain_summary}
\title{Backlinks summary}
\usage{
sst_bl_domain_summary(
  api_token,
  domain,
  search_type = "domain",
  return_method = "list"
)
}
\arguments{
\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}.}

\item{domain}{(required) A domain name to analyze.}

\item{search_type}{(optional) Default value is 'domain' for
domain only (site.com). See API docs for more details.}

\item{return_method}{(optional) Accepted values are 'list' (default) to
return data object as list or 'df' to return data object as data.frame.}
}
\value{
Returns aggregated backlinks data for the domain.
}
\description{
Returns the overview of the backlinks profile for the domain.
}
\section{API docs}{

 Check all the values for request and response fields \href{https://serpstat.com/api/887-summary-report-getsummaryv2-new-version/}{here}.
}

\section{API rows consumption}{
 1 per request.
}

\examples{
\dontrun{
api_token <- Sys.getenv('SERPSTAT_API_TOKEN')
sst_bl_domain_summary(
  api_token     = api_token,
  domain        = 'serpstat.com',
  search_type   = 'domain',
  return_method = 'list'
)$data
}
}
