% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polynomial_models.R
\name{polynomial_model}
\alias{polynomial_model}
\title{Polynomial models}
\usage{
polynomial_model(
  age,
  k,
  type,
  pos = NULL,
  tot = NULL,
  status = NULL,
  link = "log"
)
}
\arguments{
\item{age}{the age vector.}

\item{k}{degree of the model.}

\item{type}{name of method (Muench, Giffith, Grenfell).}

\item{pos}{the positive count vector (optional if status is provided).}

\item{tot}{the total count vector (optional if status is provided).}

\item{status}{the serostatus vector (optional if pos & tot are provided).}

\item{link}{link function.}
}
\value{
a list of class polynomial_model with 5 items
  \item{datatype}{type of datatype used for model fitting (aggregated or linelisting)}
  \item{df}{the dataframe used for fitting the model}
  \item{info}{fitted "glm" object}
  \item{sp}{seroprevalence}
  \item{foi}{force of infection}
}
\description{
Either `status` (treated as line-listing dataset) or  `pos` & `tot` (treated as aggregated dataset) must be provided
}
\details{
Refers to section 6.1.1
}
\examples{
data <- parvob19_fi_1997_1998[order(parvob19_fi_1997_1998$age), ]
aggregated <- transform_data(data$age, data$seropositive)

# fit with aggregated data
model <- polynomial_model(aggregated$t, pos = aggregated$pos, tot = aggregated$tot, type = "Muench")
# fit with linelisting data
model <- polynomial_model(data$age, status = data$seropositive, type = "Muench")
plot(model)

}
