% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_pop_data.R
\name{clean_pop_data}
\alias{clean_pop_data}
\title{Reformat a cross-sectional antibody survey dataset}
\usage{
clean_pop_data(pop_data)
}
\arguments{
\item{pop_data}{a \code{\link[=data.frame]{data.frame()}} containing the following columns:
\itemize{
\item \code{index_id}: a \code{\link[=character]{character()}} variable identifying multiple rows of data from the same person
\item \code{antigen_isos}: a \code{\link[=character]{character()}} variable indicating the antigen-isotype measured
\item \code{result}: the measured antibody concentration
\item \code{Age}: age of the individual whose serum has been assayed, at the time of blood sample collection.
}}
}
\value{
A \link{data.frame} (or \link[tibble:tbl_df-class]{tibble::tbl_df}) containing the following columns:
\itemize{
\item \code{id}: a \code{\link[=character]{character()}} variable identifying multiple rows of data from the same person
\item \code{antigen_isos}: a \code{\link[=character]{character()}} variable indicating the antigen-isotype measured
\item \code{value}: the measured antibody concentration
\item \code{age}: age of the individual whose serum has been assayed, at the time of blood sample
}
}
\description{
Reformat a cross-sectional antibody survey dataset
}
\examples{
\donttest{
xs_data <- load_pop_data("https://osf.io/download//n6cp3/")

clean_pop_data(xs_data)
}

}
