% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequoia_F90wrappers.R
\name{GetMaybeRel}
\alias{GetMaybeRel}
\title{Find putative relatives}
\usage{
GetMaybeRel(GenoM = NULL, SeqList = NULL, Ped = NULL,
  LifeHistData = NULL, ParSib = "par", Complex = "full",
  Err = 1e-04, MaxMismatch = 3, Tassign = 0.5, MaxPairs = 7 *
  nrow(GenoM), DumPrefix = c("F0", "M0"), quiet = FALSE)
}
\arguments{
\item{GenoM}{matrix with genotype data, size nInd x nSnp}

\item{SeqList}{list with output from \code{\link{sequoia}}. If provided, the
elements `Specs', `AgePriors' and 'LifeHist' are used, and all other input
parameters except 'GenoM', 'ParSib' and 'quiet' are ignored.}

\item{Ped}{dataframe with pedigree, with id - dam - sire in columns 1-3}

\item{LifeHistData}{dataframe with columns id - sex (1=female, 2=male,
3=unknown) - birth year}

\item{ParSib}{either 'par' to check for putative parent-offspring pairs only,
or 'sib' to check for all types of first and second degree relatives. When
'par', all pairs are returned that are more likely parent-offspring than
unrelated, including pairs that are even more likely to be otherwise
related.}

\item{Complex}{either "full" (default), "simp" (simplified, no explicit
consideration of inbred relationships), "mono" (monogamous) or "herm"
(hermaphrodites, otherwise like "full").}

\item{Err}{estimated genotyping error rate. The error model aims to deal with
scoring errors typical for SNP arrays.}

\item{MaxMismatch}{maximum number of loci at which candidate parent and
offspring are allowed to be opposite homozygotes. Setting a more liberal
threshold can improve performance if the error rate is high, at the cost of
decreased speed.}

\item{Tassign}{minimum LLR required for acceptance of proposed relationship,
relative to next most likely relationship. Higher values result in more
conservative assignments. Must be zero or positive.}

\item{MaxPairs}{The maximum number of putative pairs to return.}

\item{DumPrefix}{character vector of length 2 with prefixes for dummy dams
(mothers) and sires (fathers) used in \code{Ped}.}

\item{quiet}{suppress messages}
}
\value{
A list with
  \item{MaybeParent or MaybeRel}{Non-assigned likely relatives}
  \item{MaybeTrio}{Non-assigned parent-parent-offspring trios}
}
\description{
Identify pairs of individuals likely to be related, but not
  assigned as such in the provided pedigree.
}
\examples{
\dontrun{
data(SimGeno_example, LH_HSg5, package="sequoia")
SeqOUT <- sequoia(GenoM = SimGeno_example,
                  LifeHistData = LH_HSg5, MaxSibIter = 0)
MaybePO <- GetMaybeRel(GenoM = SimGeno_example,
                      SeqList = SeqOUT)

# age differences limit which relationships are considered:
MaybePO3 <- GetMaybeRel(GenoM = SimGeno_example,
                      Ped = SeqOUT$PedigreePar)
}
}
