\name{rvmeta.readScoreByRange}
\alias{rvmeta.readScoreByRange}
\title{Read score test statistics by range from METAL-format files.}
\usage{
rvmeta.readScoreByRange(scoreTestFiles, tabixRange)
}
\arguments{
  \item{scoreTestFiles}{character vector, score test output
  files (rvtests outputs using --meta score)}

  \item{tabixRange}{character, a text indicating which
  range in the VCF file to extract. e.g. 1:100-200}
}
\value{
score test statistics within given range
}
\description{
Read score test statistics by range from METAL-format
files.
}
\examples{
scoreFileName = system.file("rvtests/rvtest.MetaScore.assoc.anno.gz", package = "seqminer")
cfh <- rvmeta.readScoreByRange(scoreFileName, "1:196621007-196716634")
}
\seealso{
http://zhanxw.com/seqminer/ for online manual and examples
}

