% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqimpute.R
\name{seqimpute}
\alias{seqimpute}
\title{seqimpute: Imputation of missing data in longitudinal categorical data}
\usage{
seqimpute(
  data,
  var = NULL,
  np = 1,
  nf = 1,
  m = 5,
  timing = FALSE,
  frame.radius = 0,
  covariates = NULL,
  time.covariates = NULL,
  regr = "multinom",
  npt = 1,
  nfi = 1,
  ParExec = FALSE,
  ncores = NULL,
  SetRNGSeed = FALSE,
  verbose = TRUE,
  available = TRUE,
  pastDistrib = FALSE,
  futureDistrib = FALSE,
  ...
)
}
\arguments{
\item{data}{a data frame containing sequences of a categorical
variable with missing data (coded as \code{NA})}

\item{var}{the list of columns containing the trajectories. 
Default is NULL, i.e. all the columns.}

\item{np}{number of previous observations in the imputation model 
of the internal gaps.}

\item{nf}{number of future observations in the imputation model 
of the internal gaps.}

\item{m}{number of multiple imputations  (default: \code{5}).}

\item{timing}{a logical value that specifies if the MICT algorithm 
(timing=FALSE) or the MICT-timing algorithm (timing=TRUE) should be used.}

\item{frame.radius}{parameter relative to the MICT-timing algorithm 
specifying the radius of the timeframe.}

\item{covariates}{the list of columns containing the covariates to include
in the imputation process}

\item{time.covariates}{the list of columns containing the time-varying 
covariates to include in the imputation process}

\item{regr}{a character specifying the imputation method. If 
\code{regr="multinom"}, multinomial models are used, while 
if \code{regr="rf"}, random forest models are used.}

\item{npt}{number of previous observations in the imputation model 
of the terminal gaps.}

\item{nfi}{number of future observations in the imputation model 
of the initial gaps.}

\item{ParExec}{logical. If \code{TRUE}, the multiple imputations are run 
in parallel. This allows faster run time depending of how many cores 
the processor has.}

\item{ncores}{integer. Number of cores to be used for the parallel 
computation. If no value is set for this parameter, the number of cores 
will be set to the maximum number of CPU cores minus 1.}

\item{SetRNGSeed}{an integer that is used to set the seed in the case of 
parallel computation. Note that setting \code{set.seed()} alone before the 
seqimpute function won't work in case of parallel computation.}

\item{verbose}{logical. If \code{TRUE}, seqimpute will print history and 
warnings on console. Use \code{verbose=FALSE} for silent computation.}

\item{available}{a logical value allowing the user to choose whether 
to consider the already imputed data in the predictive model 
(\code{available = TRUE}) or not (\code{available = FALSE}).}

\item{pastDistrib}{a logical indicating if the past distribution should be 
used as predictor in the imputation model.}

\item{futureDistrib}{a logical indicating if the future distribution 
should be used as predictor in the imputation model.}

\item{...}{Named arguments that are passed down to the imputation functions.}
}
\value{
Returns an S3 object of class \code{seqimp}.
}
\description{
The seqimpute package implements the MICT and MICT-timing 
methods. These are multiple imputation methods for longitudinal data. 
The core idea of the algorithms is to fills gaps of missing data, which is 
the typical form of missing data in a longitudinal setting, recursively from 
their edges. The prediction is based on either a multinomial or a 
random forest regression model. Covariates and time-dependent covariates 
can be included in the model. 

The MICT-timing algorithm is an extension of the MICT algorithm designed 
to address a key limitation of the latter: its assumption that position in 
the trajectory is irrelevant.
}
\details{
The imputation process is divided into several steps, depending on
the type of gaps of missing data. The order of imputation of the gaps are:
\describe{
 \item{\code{Internal gap: }}{there is at least \code{np} observations 
 before an internal gap and \code{nf} after the gap}
 
 \item{\code{Initial gap: }}{gaps situated at the very beginning 
 of a trajectory}
 
 \item{\code{Terminal gap: }}{gaps situated at the very end
 of a trajectory}
 \item{\code{Left-hand side specifically located gap (SLG): }}{gaps 
 that have at least \code{nf} observations after the gap, but less than
 \code{np} observation before it}
 \item{\code{Right-hand side SLG: }}{gaps 
 that have at least \code{np} observations before the gap, but less than
 \code{nf} observation after it}
 \item{\code{Both-hand side SLG: }}{gaps 
 that have less than \code{np} observations before the gap, and less than
 \code{nf} observations after it}
}


The primary difference between the MICT and MICT-timing 
algorithms lies in their approach to selecting patterns from other 
sequences for fitting the multinomial model. While the MICT algorithm 
considers all similar patterns regardless of their temporal placement, 
MICT-timing restricts pattern selection to those that are temporally 
closest to the missing value. This refinement ensures that the 
imputation process adequately accounts for temporal dynamics, resulting 
in more accurate imputed values.
}
\examples{

# Default multiple imputation of the trajectories of game addiction with the
# MICT algorithm

\dontrun{
set.seed(5)
imp1 <- seqimpute(data = gameadd, var = 1:4)


# Default multiple imputation with the MICT-timing algorithm
set.seed(3)
imp2 <- seqimpute(data = gameadd, var = 1:4, timing = TRUE)


# Inclusion in the MICt-timing imputation process of the three background 
# characteristics (Gender, Age and Track), and the time-varying covariate 
# about gambling


set.seed(4)
imp3 <- seqimpute(data = gameadd, var = 1:4, covariates = 5:7, 
  time.covariates = 8:11)

  
# Parallel computation


imp4 <- seqimpute(data = gameadd, var = 1:4, covariates = 5:7, 
  time.covariates = 8:11, ParExec = TRUE, ncores=5, SetRNGSeed = 2)
}

}
\references{
HALPIN, Brendan (2012). Multiple imputation for life-course 
sequence data. Working Paper WP2012-01, Department of Sociology, 
University of Limerick. http://hdl.handle.net/10344/3639.

HALPIN, Brendan (2013). Imputing sequence data: Extensions to 
initial and terminal gaps, Stata's. Working Paper WP2013-01, 
Department of Sociology, 
University of Limerick. http://hdl.handle.net/10344/3620
}
\author{
Kevin Emery <kevin.emery@unige.ch>, Andre Berchtold,  
Anthony Guinchard, and Kamyar Taher
}
