% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulation_seqimp.R
\name{seqcomplete}
\alias{seqcomplete}
\title{Extract all the trajectories without missing value.}
\usage{
seqcomplete(data, var = NULL)
}
\arguments{
\item{data}{either a data frame containing sequences of a multinomial 
variable with missing data (coded as \code{NA}) or a state sequence 
object built with the TraMineR package}

\item{var}{the list of columns containing the trajectories. 
Default is NULL, i.e. all the columns.}
}
\value{
Returns either a data frame or a state sequence object, depending
the type of data that was provided to the function
}
\description{
Extract all the trajectories without missing value.
}
\examples{

# Game addiction dataset
data(gameadd)
# Extract the trajectories without any missing data
gameadd.complete <- seqcomplete(gameadd, var = 1:4)



}
\author{
Kevin Emery
}
