% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_mm.R
\name{build_mm}
\alias{build_mm}
\title{Build a Markov Model}
\usage{
build_mm(observations)
}
\arguments{
\item{observations}{An \code{stslist} object (see \code{\link[TraMineR]{seqdef}}) containing
the sequences.}
}
\value{
Object of class \code{hmm} with following elements:
\describe{
   \item{\code{observations}}{State sequence object or a list of such containing the data.}
   \item{\code{transition_probs}}{A matrix of transition probabilities.}
   \item{\code{emission_probs}}{A matrix or a list of matrices of emission probabilities.}
   \item{\code{initial_probs}}{A vector of initial probabilities.}
   \item{\code{state_names}}{Names for hidden states.}
   \item{\code{symbol_names}}{Names for observed states.}
   \item{\code{channel_names}}{Names for channels of sequence data.}
   \item{\code{length_of_sequences}}{(Maximum) length of sequences.}
   \item{\code{n_sequences}}{Number of sequences.}
   \item{\code{n_symbols}}{Number of observed states (in each channel).}
   \item{\code{n_states}}{Number of hidden states.}
   \item{\code{n_channels}}{Number of channels.}
}
}
\description{
Function \code{build_mm} builds and automatically estimates a Markov model. It is also a shortcut for 
constructing a Markov model as a restricted case of an \code{hmm} object.
}
\details{
Unlike the other build functions in \code{seqHMM}, the \code{build_mm} function
automatically estimates the model parameters. In case of no missing values, 
initial and transition probabilities are
directly estimated from the observed initial state probabilities and transition counts.
In case of missing values, the EM algorithm is run once.

Note that it is possible that the data contains a symbol from which there are 
no transitions anywhere (even to itself), which would lead to a row in 
transition matrix full of zeros. In this case the `build_mm` 
(as well as the EM algorithm) assumes that the 
the state is absorbing in a way that probability of staying in this state is 1.
}
\examples{
# Construct sequence data
data("mvad", package = "TraMineR")

mvad_alphabet <-
  c("employment", "FE", "HE", "joblessness", "school", "training")
mvad_labels <- c("employment", "further education", "higher education",
  "joblessness", "school", "training")
mvad_scodes <- c("EM", "FE", "HE", "JL", "SC", "TR")
mvad_seq <- seqdef(mvad, 17:86, alphabet = mvad_alphabet,
  states = mvad_scodes, labels = mvad_labels, xtstep = 6)

# Define a color palette for the sequence data
attr(mvad_seq, "cpal") <- colorpalette[[6]]

# Estimate the Markov model
mm_mvad <- build_mm(observations = mvad_seq)

}
\seealso{
\code{\link{plot.hmm}} for plotting the model.
}
