% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentolexicons.R
\name{sento_lexicons}
\alias{sento_lexicons}
\title{Set up lexicons (and valence word list) for use in sentiment analysis}
\usage{
sento_lexicons(lexiconsIn, valenceIn = NULL, do.split = FALSE)
}
\arguments{
\item{lexiconsIn}{a named \code{list} of (raw) lexicons, each element as a \code{data.table} or a \code{data.frame} with
respectively a words column and a polarity score column. The built-in lexicons
accessible via \code{list_lexicons} should be passed here first as well.}

\item{valenceIn}{a single valence word list as a \code{data.table} or a \code{data.frame} with respectively a \code{"x"}
and a \code{"y"} or \code{"t"} column. The first column has the words, \code{"y"} has the values for bigram
shifting, and \code{"t"} has the types of the valence shifter for a clustered approach to sentiment calculation
(supported types: \code{1} = negators, \code{2} = amplifiers, \code{3} = deamplifiers). If three columns
are provided, the first two will be considered only. This argument can be one of the built-in
valence word lists accessible via \code{list_valence_shifters}. A word that appears in both a lexicon
and the valence word list is prioritized as a lexical entry during sentiment calculation. If \code{NULL}, valence
shifting is not applied in the sentiment analysis.}

\item{do.split}{a \code{logical} that if \code{TRUE} splits every lexicon into a separate positive polarity and negative
polarity lexicon.}
}
\value{
A \code{list} of class \code{sentolexicons} with each lexicon as a separate element according to its name, as a
\code{data.table}, and optionally an element named \code{valence} that comprises the valence words. Every \code{"x"} column
contains the words, every \code{"y"} column contains the polarity scores. The \code{"t"} column for valence shifters
contains the valence shifting types.
}
\description{
Structures provided lexicon(s) and optionally valence words. One can for example combine (part of) the
built-in lexicons from \code{data("list_lexicons")} with other lexicons, and add one of the built-in valence word lists
from \code{data("list_valence_shifters")}. This function makes the output coherent, by converting all words to
lowercase and checking for duplicates. All entries consisting of more than one word are discarded, as required for
bag-of-words sentiment analysis.
}
\examples{
data("list_lexicons", package = "sentometrics")
data("list_valence_shifters", package = "sentometrics")

# lexicons straight from built-in word lists
l1 <- sento_lexicons(list_lexicons[c("LM_en", "HENRY_en")])

# including a self-made lexicon, with and without valence shifters
lexIn <- c(list(myLexicon = data.table(w = c("nice", "boring"), s = c(2, -1))),
           list_lexicons[c("GI_en")])
valIn <- list_valence_shifters[["en"]]
l2 <- sento_lexicons(lexIn)
l3 <- sento_lexicons(lexIn, valIn)
l4 <- sento_lexicons(lexIn, valIn[, c("x", "y")], do.split = TRUE)
l5 <- sento_lexicons(lexIn, valIn[, c("x", "t")], do.split = TRUE)
l6 <- l5[c("GI_en_POS", "valence")] # preserves sentolexicons class

\dontrun{
# include lexicons from lexicon package
lexIn2 <- list(hul = lexicon::hash_sentiment_huliu, joc = lexicon::hash_sentiment_jockers)
l7 <- sento_lexicons(c(lexIn, lexIn2), valIn)}

\dontrun{
# faulty extraction, no replacement allowed
l5["valence"]
l2[0]
l3[22]
l4[1] <- l2[1]
l4[[1]] <- l2[[1]]
l4$GI_en_NEG <- l2$myLexicon}

}
\author{
Samuel Borms
}
