% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentometrics.R
\docType{data}
\name{valence}
\alias{valence}
\title{Built-in valence word lists}
\format{A list with all built-in valence word lists, appropriately named.}
\source{
\code{\link[lexicon]{hash_valence_shifters}} (negators)
}
\usage{
data("valence")
}
\description{
A list containing all built-in valence word lists, a \code{data.table} with three columns: a \code{x} column with the
words, a \code{t} column with the type of valence words, and a \code{y} column with the values associated to each word and
type of valence shifter. The list element names incorporate the language of the valence word list. All non-English word
lists are translated via Microsoft Translator through Microsoft Word. Only the entries whose translation differs from
the original entry are kept. The valence word lists are in the form required for further sentiment analysis. All words
are in lowercase. The built-in valence word lists are the following:

\itemize{
  \item valence_eng
  \item valence_fr
  \item valence_nl
}
}
\examples{
data("valence", package = "sentometrics")
valence["valence_eng"]

}
\keyword{datasets}
