% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentometrics.R
\docType{package}
\name{sentometrics-package}
\alias{sentometrics}
\alias{sentometrics-package}
\title{An Integrated Framework for Textual Sentiment Time Series Aggregation and Prediction}
\description{
The \pkg{sentometrics} package is designed to do time series analysis based on textual sentiment. It accounts
for the intrinsic challenge that, for a given text, sentiment can be computed in many ways, as well as the large
number of possibilities to pool sentiment across text and time. This additional layer of manipulation does not exist
in standard time series analysis and text mining packages. The package also provides an automated means to
econometrically model the impact of sentiment in texts on a given variable, by first computing a wide range of textual
sentiment time series and then selecting those that are most informative. Altogether, \pkg{sentometrics} integrates the
\emph{qualification} of sentiment from texts, the \emph{aggregation} into different sentiment measures and the optimized
\emph{prediction} based on these measures.
}
\note{
The methodology behind the sentiment aggregation framework can be consulted in the working paper ``Questioning
the news about economic growth: Sparse forecasting using thousands of news-based sentiment values'' (Ardia, Bluteau, and
Boudt, 2017) at \url{https://ssrn.com/abstract=2976084}. The vignette  ``The R package sentometrics
to compute, aggregate and predict with textual sentiment'' (Ardia, Bluteau, Borms and Boudt, 2017) at
\url{https://ssrn.com/abstract=3067734} provides a hands-on introduction to the methodology and
the package's functionalities.

Please cite the package in publications. Use \code{citation("sentometrics")}.
}
\section{Main functions}{

\itemize{
\item Feature generation: \code{\link{sento_corpus}}, \code{\link{add_features}}
\item Sentiment computation and aggregation into sentiment measures: \code{\link{ctr_agg}},
\code{\link{compute_sentiment}}, \code{\link{sento_measures}}, \code{\link{merge_measures}}, \code{\link{to_global}}
\item Sparse modelling: \code{\link{ctr_model}}, \code{\link{sento_model}}
\item Prediction and post-modelling analysis: \code{\link{predict.sentomodel}}, \code{\link{retrieve_attributions}},
\code{\link{plot_attributions}}, \code{\link{perform_MCS}}
}
}

\section{Update}{

The development version of the package resides at \url{https://github.com/sborms/sentometrics}.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/sborms/sentometrics}
  \item Report bugs at \url{https://github.com/sborms/sentometrics/issues}
}

}
\author{
\strong{Maintainer}: Samuel Borms \email{samuel.borms@unine.ch}

Authors:
\itemize{
  \item David Ardia \email{david.ardia@unine.ch}
  \item Keven Bluteau \email{keven.bluteau@unine.ch}
  \item Kris Boudt \email{kris.boudt@vub.be}
}

}
