% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures.R
\name{compute_sentiment}
\alias{compute_sentiment}
\title{Compute document-level sentiment across features and lexicons}
\usage{
compute_sentiment(sentocorpus, lexicons, how = get_hows()$words, dfm = NULL)
}
\arguments{
\item{sentocorpus}{a \code{sentocorpus} object created with \code{\link{sento_corpus}}.}

\item{lexicons}{output from a \code{\link{setup_lexicons}} call.}

\item{how}{a single \code{character} vector defining how aggregation within documents should be performed. For currently
available options on how aggregation can occur, see \code{\link{get_hows}()$words}.}

\item{dfm}{optional; an output from a \pkg{quanteda} \code{\link[quanteda]{dfm}} call, such that users can specify their
own tokenization scheme (via \code{\link[quanteda]{tokens}}) as well as other parameters related to the construction of
a document-feature matrix (dfm). By default, a dfm is created based on a tokenization that removes punctuation, numbers,
symbols and separators. We suggest to stick to unigrams, as the remainder of the sentiment computation and built-in
lexicons assume the same.}
}
\value{
A \code{list} containing:
\item{corpus}{the supplied \code{sentocorpus} object; the texts are altered if valence shifters are part of the lexicons.}
\item{sentiment}{the sentiment scores \code{data.table} with a \code{"date"} and all lexicon--feature sentiment scores
columns.}
\item{features}{a \code{character} vector of the different features.}
\item{lexicons}{a \code{character} vector of the different lexicons used.}
\item{howWithin}{a \code{character} vector to remind how sentiment within documents was aggregated.}
}
\description{
Given a corpus of texts, computes sentiment per document using the bag-of-words approach
based on the lexicons provided and a choice of aggregation across words per document. Relies partly on the
\pkg{quanteda} package. The scores computed are net sentiment (sum of positive minus sum of negative scores).
}
\details{
For a separate calculation of positive (resp. negative) sentiment, one has to provide distinct positive (resp. negative)
lexicons. This can be done using the \code{do.split} option in the \code{\link{setup_lexicons}} function, which splits out
the lexicons into a positive and a negative polarity counterpart. \code{NA}s are converted to 0, under the assumption that
this is equivalent to no sentiment.
}
\examples{
data("usnews")
data("lexicons")
data("valence")

# sentiment computation based on raw frequency counts
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 1000)
l <- setup_lexicons(lexicons[c("LM_eng", "HENRY_eng")], valence[["valence_eng"]])
sent <- compute_sentiment(corpusSample, l, how = "counts")

\dontrun{
# same sentiment computation based on a user-supplied dfm with default settings
dfm <- quanteda::dfm(quanteda::tokens(corpus), verbose = FALSE)
sent <- compute_sentiment(corpusSample, l, how = "counts", dfm = dfm)}

}
\seealso{
\code{\link[quanteda]{dfm}}, \code{\link[quanteda]{tokens}}
}
\author{
Samuel Borms
}
