% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profanity.R
\name{profanity}
\alias{profanity}
\title{Compute Profanity Rate}
\usage{
profanity(text.var, profanity_list = lexicon::profanity_alvarez, ...)
}
\arguments{
\item{text.var}{The text variable.  Can be a \code{get_sentences} object or
a raw character vector though \code{get_sentences} is preferred as it avoids
the repeated cost of doing sentence boundary disambiguation every time
\code{sentiment} is run.}

\item{profanity_list}{A atomic character vector of profane words.  The 
\pkg{lexicon} package has lists that can be used, including: 
\itemize{
  \item \code{lexicon::profanity_alvarez}
  \item \code{lexicon::profanity_arr_bad}
  \item \code{lexicon::profanity_banned}
  \item \code{lexicon::profanity_zac_anger}
  \item \code{lexicon::profanity_racist}
}}

\item{\ldots}{ignored.}
}
\value{
Returns a \pkg{data.table} of:
\itemize{
  \item  element_id - The id number of the original vector passed to \code{profanity}
  \item  sentence_id - The id number of the sentences within each \code{element_id}
  \item  word_count - Word count
  \item  profanity_count - Count of the number of profane words
  \item profanity - A score of the percentage of profane words
}
}
\description{
Detect the rate of profanity at the sentence level.  This method uses a simple
dictionary lookup to find profane words and then compute the rate per sentence.
The \code{profanity} score ranges between 0 (no profanity used) and 1 (all
words used were profane).  Note that a single profane phrase would count as 
just one in the \code{profanity_count} column but would count as two words in
the \code{word_count} column.
}
\examples{
\dontrun{
bw <- sample(lexicon::profanity_alvarez, 4)
mytext <- c(
   sprintf('do you like this \%s?  It is \%s. But I hate really bad dogs', bw[1], bw[2]),
   'I am the best friend.',
   NA,
   sprintf('I \%s hate this \%s', bw[3], bw[4]),
   "Do you really like it?  I'm not happy"
)

## works on a character vector but not the preferred method avoiding the 
## repeated cost of doing sentence boundary disambiguation every time 
## `profanity` is run
profanity(mytext)

## preferred method avoiding paying the cost 
mytext2 <- get_sentences(mytext)
profanity(mytext2)

plot(profanity(mytext2))

brady <- get_sentences(crowdflower_deflategate)
brady_swears <- profanity(brady)
brady_swears
hist(brady_swears$profanity)
sum(brady_swears$profanity > 0)
hist(brady_swears$profanity[brady_swears$profanity > 0])
}
}
\concept{polarity functions}
\keyword{bad-words}
\keyword{cursing,}
\keyword{cussing,}
\keyword{profanity,}
\keyword{vulgarity,}
