% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_rescale.R
\name{general_rescale}
\alias{general_rescale}
\title{Rescale a Numeric Vector}
\usage{
general_rescale(x, lower = -1, upper = 1, mute = NULL,
  keep.zero = lower < 0, sign = FALSE, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{lower}{An upper limit to rescale to.}

\item{upper}{A lower limit to rescale to.}

\item{mute}{A positive value greater than 1 to lower the extremes and pull 
the fractions up.  This becomes the denominator in a power to raise each 
element by (sign is retained) where the numerator is 1.  This is useful for 
mellowing out the extremes.}

\item{keep.zero}{logical.  If \code{TRUE} the zeros are kept as neutral.}

\item{sign}{logical.  If \code{TRUE} the vector will be scaled as (-1, 1, or 0)}

\item{\ldots}{ignored.}
}
\value{
Returns a rescaled vector of the same length as \code{x}.
}
\description{
Rescale a numeric vector with the option to make signed (-1, 1, or 0) and 
retain zero as neutral.
}
\examples{

general_rescale(c(1, 0, -1))
general_rescale(c(1, 0, -1, 1.4, -2))
general_rescale(c(1, 0, -1, 1.4, -2), lower = 0, upper = 1)
general_rescale(c(NA, -4:3))
general_rescale(c(NA, -4:3), keep.zero = FALSE)
general_rescale(c(NA, -4:3), keep.zero = FALSE, lower = 0, upper = 100)

## mute extreme values
set.seed(10)
x <- sort(c(NA, -100, -10, 0, rnorm(10, 0, .1), 10, 100), na.last = FALSE)
general_rescale(x)
general_rescale(x, mute = 5)
general_rescale(x, mute = 10)
general_rescale(x, mute = 100)
}
