% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.effects.R
\name{calc.effects}
\alias{calc.effects}
\title{Function for estimation of natural direct and indirect effects and sensitivity analysis for unobserved mediator-outcome confounding}
\usage{
calc.effects(ML.object, type = "my", exp.name, med.name,
  covariates = NULL, alt.decomposition = FALSE, exp.value = 1,
  control.value = 0, med.model = NULL, out.model = NULL)
}
\arguments{
\item{ML.object}{object from \code{\link{coefs.sensmed}}}

\item{type}{the type of confounding for which the sensitivity analysis is to be performed. \code{type = "my"},  the default, corresponds to unobserved mediator-outcome
confounding,  \code{type = "zm"} to exposure-mediator confounding and \code{type = "zy"} to exposure-outcome confounding.}

\item{exp.name}{A character string indicating the name of the exposure variable used in the models.}

\item{med.name}{A character string indicating the name of the mediator used in the models.}

\item{covariates}{if conditional effects are to be estimated the list of covariate values. Covariates not specified are marginalized over. For more information, see \code{\link{sensmediation}}.}

\item{alt.decomposition}{logical indicating whether alternative definitions of the direct and indirect effects should be used (for more information, see \code{\link{sensmediation}}).}

\item{exp.value}{value of the exposure variable used as the exposure condition, default is 1.}

\item{control.value}{value of the exposure variable used as the control (unexposed) condition, default is 0.}

\item{med.model}{If \code{type = "zy"},  fitted \code{\link{glm}} model object representing the mediator model at the basis of the estimation.}

\item{out.model}{If \code{type = "zm"},  fitted \code{\link{glm}} model object representing the outcome model at the basis of the estimation.}
}
\value{
A list with elements:
\item{effects}{A list with elements \code{NIE} and \code{NDE},  row matrices with the estimated NIE and NDE (or NIE* and NDE* if \code{alt.decomposition = TRUE}) for each value of the sensitivity parameter \code{Rho}.}
\item{std.errs}{A list with elements \code{se.nie} and \code{se.nde},  row matrices with the estimated standard errors for the natural direct and indirect effects for the different values of the sensitivity parameter \code{Rho}.}
\item{betas}{list of the estimated mediator model parameters over \code{Rho}, with
\itemize{
\item \code{beta0} Intercept
\item \code{beta1} Exposure
\item \code{beta2} Covariates
\item \code{beta3} Exposure-covariate interactions
}
Components that are not included in the input mediator model are set to 0.}
\item{thetas}{list of the estimated outcome model parameters over \code{Rho}, with
\itemize{
\item \code{theta0} Intercept
\item \code{theta1} Exposure
\item \code{theta2} Mediator
\item \code{theta3} Exposure-mediator interaction
\item \code{theta4} Covariates
\item \code{theta5} Exposure-covariate interactions
\item \code{theta6} Mediator-covariate interactions
\item \code{theta7} Exposure-mediator-covariate interactions
}
Components that are not included in the input outcome model are set to 0.}
\item{part.deriv}{List with the partial derivatives of the NDE (Lambda), NIE (Gamma) and TE (Eta) wrt the mediator and outcome model parameters for each value of \code{Rho}}
\item{sigma.thetabeta}{a list with the joint covariance matrix of the outcome and mediator model parameters for each value of \code{Rho}. Note that the covariance matrix is constructed for all estimated parameters listed in \code{betas} and \code{thetas} but that components not included in the input mediator and outcome models are set to 0.}
\item{covariates}{list of the covariate values that the effects are conditioned on.}
}
\description{
Function to estimate natural direct and indirect effect estimates and standard errors (using the delta method) based on parametric regression models and perform sensitivity analysis for unobserved confounding.
Intended to be called through \code{\link{sensmediation}} (or \code{\link{more.effects}}),  not on its own.
}
\seealso{
\code{\link{sensmediation}}
}
\author{
Anita Lindmark
}
